/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewerWithVerticalSplit;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.RowLayoutManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.DataSetProteinGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinRenderers;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinSamplesSection;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinSequenceGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.IBasicProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.IndistinguishableProteinInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Peptide;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinByExperiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinDetails;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProteinViewer
extends AbstractViewerWithVerticalSplit<IEntityInformationHolder>
implements IDatabaseModificationObserver {
    private static final int AMINOACIDS_IN_ONE_BLOCK = 10;
    private static final String PREFIX = "protein-viewer_";
    public static final String ID_PREFIX = "openbis_protein-viewer_";
    private final Experiment experimentOrNull;
    private final IBasicProteinInfo proteinInfo;
    private final TechId proteinReferenceID;
    private ProteinSamplesSection proteinSamplesSection;

    static AbstractTabItemFactory createTabItemFactory(final IViewContext<IPhosphoNetXClientServiceAsync> viewContext, final Experiment experiment, final IBasicProteinInfo proteinInfo) {
        return new AbstractTabItemFactory(){

            @Override
            public String getId() {
                return ProteinViewer.createWidgetID(experiment, proteinInfo.getId());
            }

            @Override
            public ITabItem create() {
                ProteinViewer viewer = new ProteinViewer(viewContext, experiment, proteinInfo, null);
                DatabaseModificationAwareComponent c = new DatabaseModificationAwareComponent((Component)viewer, (IDatabaseModificationObserver)viewer);
                return DefaultTabItem.create(this.getTabTitle(), c, viewContext, false);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return HelpPageIdentifier.createSpecific("Protein Viewer");
            }

            @Override
            public String getTabTitle() {
                String description = ProteinViewer.getAbbreviatedDescription(proteinInfo);
                String identifier = experiment == null ? "?" : experiment.getCode();
                return viewContext.getMessage("protein_in_experiment_tab_label", description, identifier);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
    }

    private static String getAbbreviatedDescription(IBasicProteinInfo proteinInfo) {
        String info = proteinInfo.getDescription();
        if (info == null) {
            info = proteinInfo.getAccessionNumber();
        }
        return StringUtils.abbreviate(info, 30);
    }

    static String createWidgetID(IIdAndCodeHolder experimentIdOrNull, TechId proteinReferenceID) {
        Long experimentID = experimentIdOrNull == null ? null : experimentIdOrNull.getId();
        return ID_PREFIX + experimentID + "_" + proteinReferenceID.getId();
    }

    private ProteinViewer(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, Experiment experiment, IBasicProteinInfo proteinInfo) {
        super(viewContext, "", ProteinViewer.createWidgetID(experiment, proteinInfo.getId()), false);
        this.experimentOrNull = experiment;
        this.proteinInfo = proteinInfo;
        this.proteinReferenceID = proteinInfo.getId();
        this.reloadAllData();
    }

    @Override
    protected final IViewContext<IPhosphoNetXClientServiceAsync> getViewContext() {
        return this.viewContext;
    }

    @Override
    protected void reloadAllData() {
        if (this.experimentOrNull != null) {
            IViewContext<IPhosphoNetXClientServiceAsync> context = this.getViewContext();
            ProteinByExperimentCallback callback = new ProteinByExperimentCallback(context, this);
            String message = context.getMessage("loading_protein_details_waiting_message", this.proteinInfo.getAccessionNumber());
            context.getService().getProteinByExperiment(new TechId(this.experimentOrNull.getId()), this.proteinReferenceID, AsyncCallbackWithProgressBar.decorate(callback, message));
        }
    }

    private void recreateUI(ProteinByExperiment protein) {
        this.setLayout((Layout)new BorderLayout());
        this.removeAll();
        this.setScrollMode(Style.Scroll.AUTO);
        ContentPanel propertyPanel = this.createPropertyPanel(protein);
        ProteinDetails details = protein.getDetails();
        if (details == null) {
            this.recreateUIWithDatasetTable(protein, propertyPanel);
        } else {
            LayoutContainer centerPanel = new LayoutContainer();
            RowLayoutManager rowDataManager = new RowLayoutManager(centerPanel, new RowLayout());
            this.add((Widget)centerPanel, (LayoutData)ProteinViewer.createBorderLayoutData(Style.LayoutRegion.CENTER));
            rowDataManager.addToContainer(propertyPanel, new RowData(1.0, 0.5));
            List<IndistinguishableProteinInfo> indistinguishableProteins = details.getIndistinguishableProteinInfos();
            if (!indistinguishableProteins.isEmpty()) {
                List<Peptide> peptides = details.getPeptides();
                ContentPanel panel = this.createIndistinguishableProteinsSection(indistinguishableProteins, peptides);
                rowDataManager.addToContainer(panel, new RowData(1.0, (double)0.3f));
            }
            this.proteinSamplesSection = new ProteinSamplesSection(this.getViewContext(), this.proteinReferenceID, this.experimentOrNull);
            rowDataManager.addToContainer(this.proteinSamplesSection, new RowData(1.0, (double)0.2f));
            this.layout();
        }
    }

    private ContentPanel createIndistinguishableProteinsSection(List<IndistinguishableProteinInfo> indistinguishableProteins, List<Peptide> peptides) {
        ContentPanel panel = new ContentPanel((Layout)new RowLayout());
        panel.setHeading(this.viewContext.getMessage("indistinguishable_proteins", new Object[0]));
        panel.setCollapsible(true);
        panel.setHeight("100%");
        TabPanel tabPanel = new TabPanel();
        tabPanel.setTabScroll(true);
        for (IndistinguishableProteinInfo info : indistinguishableProteins) {
            String accessionNumber = info.getAccessionNumber();
            TabItem item = new TabItem(accessionNumber);
            item.setLayout((Layout)new FitLayout());
            PropertyGrid propertyGrid = new PropertyGrid(this.viewContext, 4, "200");
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put(this.viewContext.getMessage("accession_number", new Object[0]), info);
            propertyGrid.registerPropertyValueRenderer(IndistinguishableProteinInfo.class, ProteinRenderers.createProteinIdentLinkRenderer(this.viewContext));
            properties.put(this.viewContext.getMessage("protein_description", new Object[0]), info.getDescription());
            String markedSequence = ProteinViewer.markPeptides(info.getSequence(), peptides);
            properties.put(this.viewContext.getMessage("sequence_name", new Object[0]), markedSequence);
            properties.put(this.viewContext.getMessage("coverage", new Object[0]), info.getCoverage());
            propertyGrid.setProperties(properties);
            ContentPanel contentPanel = new ContentPanel();
            contentPanel.setHeight("100%");
            contentPanel.setScrollMode(Style.Scroll.AUTO);
            contentPanel.add((Widget)propertyGrid);
            item.add((Widget)contentPanel);
            tabPanel.add(item);
        }
        panel.add((Widget)tabPanel, (LayoutData)new RowData(1.0, 1.0));
        return panel;
    }

    private void recreateUIWithDatasetTable(ProteinByExperiment protein, ContentPanel propertyPanel) {
        BorderLayoutData layoutData = ProteinViewer.createBorderLayoutData(Style.LayoutRegion.WEST);
        layoutData.setSize(400.0f);
        this.add((Widget)propertyPanel, (LayoutData)layoutData);
        DisposableTabContent sequencesSection = new DisposableTabContent(this.viewContext.getMessage("sequences", new Object[0]), this.viewContext, this.proteinReferenceID){

            @Override
            protected IDisposableComponent createDisposableContent() {
                return ProteinSequenceGrid.create(ProteinViewer.this.getViewContext(), ProteinViewer.this.experimentOrNull, ProteinViewer.this.proteinReferenceID);
            }
        };
        this.add((Widget)sequencesSection, (LayoutData)ProteinViewer.createRightBorderLayoutData());
        DisposableTabContent proteinsSection = new DisposableTabContent(this.viewContext.getMessage("data_set_proteins", new Object[0]), this.viewContext, this.proteinReferenceID){

            @Override
            protected IDisposableComponent createDisposableContent() {
                return DataSetProteinGrid.create(ProteinViewer.this.getViewContext(), ProteinViewer.this.experimentOrNull, ProteinViewer.this.proteinReferenceID);
            }
        };
        this.add((Widget)proteinsSection, (LayoutData)ProteinViewer.createBorderLayoutData(Style.LayoutRegion.SOUTH));
        this.layout();
        sequencesSection.setContentVisible(true);
        proteinsSection.setContentVisible(true);
    }

    private ContentPanel createPropertyPanel(ProteinByExperiment protein) {
        PropertyGrid propertyGrid = this.createPropertyGrid(protein);
        ContentPanel contentPanel = new ContentPanel();
        contentPanel.setHeading(this.viewContext.getMessage("primary_protein", new Object[0]));
        contentPanel.setScrollMode(Style.Scroll.AUTO);
        contentPanel.setCollapsible(true);
        contentPanel.add((Widget)propertyGrid);
        return contentPanel;
    }

    private PropertyGrid createPropertyGrid(ProteinByExperiment protein) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        PropertyGrid propertyGrid = new PropertyGrid(this.viewContext, 0, "200");
        if (this.experimentOrNull != null) {
            properties.put(this.viewContext.getMessage("experiment_label", new Object[0]), this.experimentOrNull);
        }
        properties.put(this.viewContext.getMessage("accession_number", new Object[0]), protein);
        propertyGrid.registerPropertyValueRenderer(ProteinByExperiment.class, ProteinRenderers.createProteinIdentLinkRenderer(this.viewContext));
        properties.put(this.viewContext.getMessage("protein_description", new Object[0]), protein.getDescription());
        if (protein.getDetails() != null) {
            this.addProteinDetails(properties, propertyGrid, protein.getDetails());
        }
        propertyGrid.resizeRows(properties.size());
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private void addProteinDetails(Map<String, Object> properties, PropertyGrid propertyGrid, ProteinDetails proteinDetails) {
        properties.put(this.viewContext.getMessage("database_name_and_version", new Object[0]), proteinDetails.getDatabaseNameAndVersion());
        String markedSequence = ProteinViewer.markPeptides(proteinDetails.getSequence(), proteinDetails.getPeptides());
        properties.put(this.viewContext.getMessage("sequence_name", new Object[0]), markedSequence);
        properties.put(this.viewContext.getMessage("coverage", new Object[0]), proteinDetails.getCoverage());
        propertyGrid.registerPropertyValueRenderer(Peptide.class, ProteinRenderers.createPeptideRenderer(this.viewContext));
        properties.put(this.viewContext.getMessage("peptides", proteinDetails.getPeptides().size()), proteinDetails.getPeptides().toArray());
        properties.put(this.viewContext.getMessage("protein_probability", new Object[0]), proteinDetails.getProbability());
        properties.put(this.viewContext.getMessage("false_discovery_rate_column", new Object[0]), proteinDetails.getFalseDiscoveryRate());
        DatasetInformationHolder dataset = new DatasetInformationHolder(proteinDetails);
        properties.put(this.viewContext.getMessage("data_set_perm_id", new Object[0]), dataset);
        propertyGrid.registerPropertyValueRenderer(DatasetInformationHolder.class, ProteinRenderers.createEntityInformationPropertyValueRenderer(this.viewContext));
    }

    private static String markPeptides(String sequence, List<Peptide> peptides) {
        String markedSequence = ProteinRenderers.markOccurrencesWithHtml(sequence, peptides, 10);
        return ProteinRenderers.getFixedWidthHTMLString(markedSequence);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.createDatabaseModificationObserver().getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.createDatabaseModificationObserver().update(observedModifications);
    }

    private CompositeDatabaseModificationObserver createDatabaseModificationObserver() {
        CompositeDatabaseModificationObserver observer = new CompositeDatabaseModificationObserver();
        if (this.proteinSamplesSection != null) {
            observer.addObserver(this.proteinSamplesSection.tryGetDatabaseModificationObserver());
        }
        return observer;
    }

    @Override
    protected String getDeleteButtonLabel() {
        return this.viewContext.getMessage("button_delete_protein", new Object[0]);
    }

    /* synthetic */ ProteinViewer(IViewContext iViewContext, Experiment experiment, IBasicProteinInfo iBasicProteinInfo, ProteinViewer proteinViewer) {
        this(iViewContext, experiment, iBasicProteinInfo);
    }

    public static class DatasetInformationHolder
    implements IEntityInformationHolderWithIdentifier {
        private static final long serialVersionUID = 35L;
        private final ProteinDetails proteinDetails;

        public DatasetInformationHolder(ProteinDetails proteinDetails) {
            this.proteinDetails = proteinDetails;
        }

        @Override
        public EntityKind getEntityKind() {
            return EntityKind.DATA_SET;
        }

        @Override
        public EntityType getEntityType() {
            DataSetType dataSetType = new DataSetType();
            dataSetType.setCode(this.proteinDetails.getDataSetTypeCode());
            return dataSetType;
        }

        @Override
        public String getIdentifier() {
            return this.proteinDetails.getDataSetPermID();
        }

        @Override
        public Long getId() {
            return this.proteinDetails.getDataSetTechID();
        }

        @Override
        public String getCode() {
            return this.proteinDetails.getDataSetPermID();
        }

        @Override
        public String getPermId() {
            return this.getIdentifier();
        }
    }

    private static final class ProteinByExperimentCallback
    extends AbstractAsyncCallback<ProteinByExperiment> {
        private final ProteinViewer viewer;

        private ProteinByExperimentCallback(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, ProteinViewer viewer) {
            super(viewContext);
            this.viewer = viewer;
        }

        @Override
        protected final void process(ProteinByExperiment result) {
            this.viewer.recreateUI(result);
        }
    }
}

