/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.IBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleProvider;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

class SampleProvider
implements ISampleProvider {
    private final Session session;
    private final IBusinessObjectFactory boFactory;
    private Map<String, Sample> samplesByPermIDs;

    SampleProvider(Session session, IBusinessObjectFactory boFactory) {
        this.session = session;
        this.boFactory = boFactory;
    }

    @Override
    public void loadByExperimentID(TechId experimentID) {
        this.samplesByPermIDs = new HashMap<String, Sample>();
        ListSampleCriteria criteria = ListSampleCriteria.createForExperiment(experimentID);
        ISampleLister lister = this.boFactory.createSampleLister(this.session);
        ListOrSearchSampleCriteria criteria2 = new ListOrSearchSampleCriteria(criteria);
        criteria2.setEnrichDependentSamplesWithProperties(true);
        this.gatherSamplesAndAncestorsRecursively(lister, criteria2);
    }

    private void gatherSamplesAndAncestorsRecursively(ISampleLister lister, ListOrSearchSampleCriteria criteria) {
        List<Sample> list = lister.list(criteria);
        LinkedHashSet<Long> sampleIDs = new LinkedHashSet<Long>();
        for (Sample sample : list) {
            this.samplesByPermIDs.put(sample.getPermId(), sample);
            sampleIDs.add(sample.getId());
        }
        if (sampleIDs.isEmpty()) {
            return;
        }
        ListSampleCriteria criteria2 = ListSampleCriteria.createForChildren(sampleIDs);
        ListOrSearchSampleCriteria criteria3 = new ListOrSearchSampleCriteria(criteria2);
        criteria3.setEnrichDependentSamplesWithProperties(true);
        this.gatherSamplesAndAncestorsRecursively(lister, criteria3);
    }

    @Override
    public Sample getSample(String permID) {
        Sample sample = this.samplesByPermIDs.get(permID);
        if (sample == null) {
            throw new UserFailureException("No sample with following perm ID registered in openBIS: " + permID);
        }
        return sample;
    }
}

