/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Treatment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TreatmentFinder {
    public static final String TREATMENT_TYPE_CODE = "TREATMENT_TYPE";
    public static final String TREATMENT_VALUE_CODE = "TREATMENT_VALUE";

    public List<Treatment> findTreatmentsOf(Sample sample) {
        LinkedHashMap<String, Treatment> treatments = new LinkedHashMap<String, Treatment>();
        this.findAndAddTreatments(treatments, sample);
        ArrayList<Treatment> treatmentList = new ArrayList<Treatment>(treatments.values());
        Collections.sort(treatmentList);
        return treatmentList;
    }

    private void findAndAddTreatments(Map<String, Treatment> treatments, Sample sampleOrNull) {
        if (sampleOrNull == null) {
            return;
        }
        this.findAndAddTreatments(treatments, sampleOrNull.getGeneratedFrom());
        List<IEntityProperty> properties = sampleOrNull.getProperties();
        HashMap<String, Treatment> codeTreatmentMap = new HashMap<String, Treatment>();
        for (IEntityProperty property : properties) {
            String treatmentCode;
            PropertyType propertyType = property.getPropertyType();
            String code = propertyType.getCode();
            if (code.startsWith(TREATMENT_TYPE_CODE)) {
                treatmentCode = code.substring(TREATMENT_TYPE_CODE.length());
                VocabularyTerm vocabularyTerm = property.getVocabularyTerm();
                if (vocabularyTerm == null) {
                    throw new UserFailureException("Data type of property type '" + code + "' must be a vocabulary.");
                }
                Treatment treatment = this.getOrCreateTreatment(codeTreatmentMap, treatmentCode);
                treatment.setType(this.getLabelOrCode(vocabularyTerm));
                treatment.setTypeCode(vocabularyTerm.getCode());
                continue;
            }
            if (!code.startsWith(TREATMENT_VALUE_CODE)) continue;
            treatmentCode = code.substring(TREATMENT_VALUE_CODE.length());
            Treatment treatment = this.getOrCreateTreatment(codeTreatmentMap, treatmentCode);
            DataTypeCode dataType = propertyType.getDataType().getCode();
            treatment.setValueType(dataType.toString());
            String value = this.getValue(property);
            treatment.setValue(value);
        }
        Collection treatmentsToBeAdded = codeTreatmentMap.values();
        for (Treatment treatment : treatmentsToBeAdded) {
            Treatment superTreatment = treatments.get(treatment.getType());
            if (superTreatment == null) {
                treatments.put(treatment.getType(), treatment);
                continue;
            }
            superTreatment.setValue(treatment.getValue());
        }
    }

    private String getValue(IEntityProperty property) {
        Material material = property.getMaterial();
        if (material != null) {
            return material.getCode();
        }
        VocabularyTerm vocabularyTerm = property.getVocabularyTerm();
        return vocabularyTerm == null ? property.getValue() : this.getLabelOrCode(vocabularyTerm);
    }

    private String getLabelOrCode(VocabularyTerm vocabularyTerm) {
        String label = vocabularyTerm.getLabel();
        if (StringUtils.isBlank((String)label)) {
            label = vocabularyTerm.getCode();
        }
        return label;
    }

    private Treatment getOrCreateTreatment(Map<String, Treatment> codeTreatmentMap, String treatmentCode) {
        Treatment treatment = codeTreatmentMap.get(treatmentCode);
        if (treatment == null) {
            treatment = new Treatment();
            treatment.setType("");
            treatment.setTypeCode("");
            treatment.setValue("");
            treatment.setValueType(DataTypeCode.VARCHAR.toString());
            codeTreatmentMap.put(treatmentCode, treatment);
        }
        return treatment;
    }
}

