/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model;

import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers.heatmaps.model.IRangeCalculator;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.Range;
import java.util.Collections;
import java.util.List;

public class PercentileRangeCalculator
implements IRangeCalculator {
    private int minPercentile;
    private final int maxPercentile;

    public PercentileRangeCalculator(int minPercentile, int maxPercentile) {
        this.minPercentile = minPercentile;
        this.maxPercentile = maxPercentile;
    }

    @Override
    public Range calculate(List<Float> numbers) {
        Collections.sort(numbers);
        return new Range(this.pick(numbers, this.minPercentile), this.pick(numbers, this.maxPercentile));
    }

    private float pick(List<Float> numbers, int percentile) {
        int index2;
        int size = numbers.size();
        double rank = (double)percentile * 0.01 * (double)size - 0.5;
        int index1 = this.trim(Math.floor(rank), size);
        if (index1 == (index2 = this.trim(Math.ceil(rank), size))) {
            return numbers.get(index1).floatValue();
        }
        float f1 = numbers.get(index1).floatValue();
        float f2 = numbers.get(index2).floatValue();
        return (float)((double)f1 * ((double)index2 - rank) + (double)f2 * (rank - (double)index1));
    }

    private int trim(double index, int size) {
        return Math.max(0, Math.min(size - 1, (int)index));
    }
}

