/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterWriteStrategy;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.PngFilterType;
import ar.com.hjg.pngj.PngHelper;
import ar.com.hjg.pngj.PngIDatChunkOutputStream;
import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunksToWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngChunkPLTE;
import ar.com.hjg.pngj.chunks.PngChunkTextVar;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PngWriter {
    public final ImageInfo imgInfo;
    private int compLevel = 6;
    private FilterWriteStrategy filterStrat;
    private int rowNum = -1;
    private int[] scanline = null;
    private int[] rowb = null;
    private int[] rowbprev = null;
    private byte[] rowbfilter = null;
    private final OutputStream os;
    private final String filename;
    private PngIDatChunkOutputStream datStream;
    private DeflaterOutputStream datStreamDeflated;
    private ChunksToWrite chunks;
    private WriteStep step;

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo) {
        this(outputStream, imgInfo, "[NO FILENAME AVAILABLE]");
    }

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo, String filenameOrDescription) {
        this.filename = filenameOrDescription == null ? "" : filenameOrDescription;
        this.os = outputStream;
        this.imgInfo = imgInfo;
        this.scanline = new int[imgInfo.samplesPerRowP];
        this.rowb = new int[imgInfo.bytesPerRow + 1];
        this.rowbprev = new int[this.rowb.length];
        this.rowbfilter = new byte[this.rowb.length];
        this.datStream = new PngIDatChunkOutputStream(this.os);
        this.chunks = new ChunksToWrite(imgInfo);
        this.step = WriteStep.START;
        this.filterStrat = new FilterWriteStrategy(imgInfo, PngFilterType.FILTER_DEFAULT);
    }

    private void writeSignatureAndIHDR() {
        if (this.datStreamDeflated == null) {
            this.datStreamDeflated = new DeflaterOutputStream((OutputStream)this.datStream, new Deflater(this.compLevel));
        }
        PngHelper.writeBytes(this.os, PngHelper.pngIdBytes);
        this.step = WriteStep.IDHR;
        PngChunkIHDR ihdr = new PngChunkIHDR(this.imgInfo);
        ihdr.cols = this.imgInfo.cols;
        ihdr.rows = this.imgInfo.rows;
        ihdr.bitspc = this.imgInfo.bitDepth;
        int colormodel = 0;
        if (this.imgInfo.alpha) {
            colormodel += 4;
        }
        if (this.imgInfo.indexed) {
            ++colormodel;
        }
        if (!this.imgInfo.greyscale) {
            colormodel += 2;
        }
        ihdr.colormodel = colormodel;
        ihdr.compmeth = 0;
        ihdr.filmeth = 0;
        ihdr.interlaced = 0;
        ihdr.createChunk().writeChunk(this.os);
        this.step = WriteStep.IDHR_DONE;
    }

    private void writeFirstChunks() {
        this.step = WriteStep.FIRST_CHUNKS;
        PngChunk paletteChunk = null;
        for (PngChunk chunk : this.chunks.getPending()) {
            if (chunk.beforePLTE) {
                chunk.writeAndMarkAsWrite(this.os);
            }
            if (!(chunk instanceof PngChunkPLTE)) continue;
            paletteChunk = (PngChunkPLTE)chunk;
        }
        if (paletteChunk != null) {
            if (this.imgInfo.greyscale) {
                throw new PngjOutputException("cannot write palette for this format");
            }
            paletteChunk.writeAndMarkAsWrite(this.os);
        } else if (this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        for (PngChunk chunk : this.chunks.getPending()) {
            boolean prio;
            boolean bl = prio = chunk.getWriteStatus() == 1;
            if (!chunk.beforeIDAT && !prio) continue;
            chunk.writeAndMarkAsWrite(this.os);
        }
        this.step = WriteStep.FIRST_CHUNKS_DONE;
    }

    private void writeLastChunks() {
        this.step = WriteStep.LAST_CHUNKS;
        for (PngChunk chunk : this.chunks.getPending()) {
            if (chunk.beforePLTE || chunk.beforeIDAT) {
                throw new PngjOutputException("too late to write this chunk: " + chunk.id);
            }
            chunk.writeAndMarkAsWrite(this.os);
        }
        this.step = WriteStep.LAST_CHUNKS_DONE;
    }

    private void writeEndChunk() {
        PngChunkIEND c = new PngChunkIEND(this.imgInfo);
        c.createChunk().writeChunk(this.os);
        this.step = WriteStep.END;
    }

    private void writeDataBeforeIDAT() {
        if (this.step == WriteStep.START) {
            this.writeSignatureAndIHDR();
        }
        if (this.step == WriteStep.IDHR_DONE) {
            this.writeFirstChunks();
        }
        if (this.step != WriteStep.FIRST_CHUNKS_DONE) {
            throw new PngjOutputException("unexpected state before idat write: " + (Object)((Object)this.step));
        }
    }

    public void writeRow(int[] newrow, int n) {
        if (this.step != WriteStep.IDAT) {
            this.writeDataBeforeIDAT();
            this.step = WriteStep.IDAT;
        }
        if (n < 0 || n > this.imgInfo.rows) {
            throw new RuntimeException("invalid value for row " + n);
        }
        ++this.rowNum;
        if (this.rowNum != n) {
            throw new RuntimeException("write order must be strict for rows " + n + " (expected=" + this.rowNum + ")");
        }
        this.scanline = newrow;
        int[] tmp = this.rowb;
        this.rowb = this.rowbprev;
        this.rowbprev = tmp;
        this.convertRowToBytes();
        this.filterRow(n);
        try {
            this.datStreamDeflated.write(this.rowbfilter, 0, this.imgInfo.bytesPerRow + 1);
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    public void writeRow(ImageLine imgline) {
        this.writeRow(imgline.scanline, imgline.getRown());
    }

    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            this.datStreamDeflated.finish();
            this.datStream.flush();
            this.step = WriteStep.IDAT_DONE;
            this.writeLastChunks();
            this.writeEndChunk();
            this.os.close();
        }
        catch (IOException e) {
            throw new PngjOutputException(e);
        }
    }

    private void filterRow(int rown) {
        if (this.filterStrat.shouldTestAll(rown)) {
            this.filterRowNone();
            this.filterStrat.fillResultsForFilter(rown, PngFilterType.FILTER_NONE, this.sumRowbfilter());
            this.filterRowSub();
            this.filterStrat.fillResultsForFilter(rown, PngFilterType.FILTER_SUB, this.sumRowbfilter());
            this.filterRowUp();
            this.filterStrat.fillResultsForFilter(rown, PngFilterType.FILTER_UP, this.sumRowbfilter());
            this.filterRowAverage();
            this.filterStrat.fillResultsForFilter(rown, PngFilterType.FILTER_AVERAGE, this.sumRowbfilter());
            this.filterRowPaeth();
            this.filterStrat.fillResultsForFilter(rown, PngFilterType.FILTER_PAETH, this.sumRowbfilter());
        }
        PngFilterType filterType = this.filterStrat.gimmeFilterType(rown);
        this.rowbfilter[0] = (byte)filterType.val;
        switch (filterType) {
            case FILTER_NONE: {
                this.filterRowNone();
                break;
            }
            case FILTER_SUB: {
                this.filterRowSub();
                break;
            }
            case FILTER_UP: {
                this.filterRowUp();
                break;
            }
            case FILTER_AVERAGE: {
                this.filterRowAverage();
                break;
            }
            case FILTER_PAETH: {
                this.filterRowPaeth();
                break;
            }
            default: {
                throw new PngjOutputException("Filter type " + (Object)((Object)filterType) + " not implemented");
            }
        }
    }

    private long sumRowbfilter() {
        long s = 0L;
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            s = this.rowbfilter[i] < 0 ? (s -= (long)this.rowbfilter[i]) : (s += (long)this.rowbfilter[i]);
            ++i;
        }
        return s;
    }

    private void filterRowNone() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[i] = (byte)this.rowb[i];
            ++i;
        }
    }

    private void filterRowSub() {
        int i = 1;
        while (i <= this.imgInfo.bytesPixel) {
            this.rowbfilter[i] = (byte)this.rowb[i];
            ++i;
        }
        int j = 1;
        i = this.imgInfo.bytesPixel + 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowb[j]);
            ++i;
            ++j;
        }
    }

    private void filterRowUp() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            this.rowbfilter[i] = (byte)(this.rowb[i] - this.rowbprev[i]);
            ++i;
        }
    }

    private void filterRowAverage() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            if (this.rowb[i] < 0 || this.rowb[i] > 255) {
                throw new PngjOutputException("??" + this.rowb[i]);
            }
            if (this.rowbprev[i] < 0 || this.rowbprev[i] > 255) {
                throw new PngjOutputException("??" + this.rowbprev[i]);
            }
            ++i;
        }
        int j = 1 - this.imgInfo.bytesPixel;
        i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            this.rowbfilter[i] = (byte)(this.rowb[i] - (this.rowbprev[i] + x) / 2);
            ++i;
            ++j;
        }
    }

    private void filterRowPaeth() {
        int i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            if (this.rowb[i] < 0 || this.rowb[i] > 255) {
                throw new PngjOutputException("??" + this.rowb[i] + " i=" + i + " row=" + this.rowNum);
            }
            if (this.rowbprev[i] < 0 || this.rowbprev[i] > 255) {
                throw new PngjOutputException("??" + this.rowbprev[i]);
            }
            ++i;
        }
        int j = 1 - this.imgInfo.bytesPixel;
        i = 1;
        while (i <= this.imgInfo.bytesPerRow) {
            int x = j > 0 ? this.rowb[j] : 0;
            int y = j > 0 ? this.rowbprev[j] : 0;
            this.rowbfilter[i] = (byte)(this.rowb[i] - PngHelper.filterPaethPredictor(x, this.rowbprev[i], y));
            ++i;
            ++j;
        }
    }

    private void convertRowToBytes() {
        if (this.imgInfo.bitDepth <= 8) {
            int i = 0;
            int j = 1;
            while (i < this.imgInfo.samplesPerRowP) {
                this.rowb[j++] = this.scanline[i] & 0xFF;
                ++i;
            }
        } else {
            int i = 0;
            int j = 1;
            while (i < this.imgInfo.samplesPerRowP) {
                int x = this.scanline[i] & 0xFFFF;
                this.rowb[j++] = (x & 0xFF00) >> 8;
                this.rowb[j++] = x & 0xFF;
                ++i;
            }
        }
    }

    public void setDpi(double dpi) {
        this.chunks.setPHYSdpi(dpi);
    }

    public void setFilterType(PngFilterType filterType) {
        this.filterStrat = new FilterWriteStrategy(this.imgInfo, filterType);
    }

    public void setCompLevel(int compLevel) {
        if (compLevel < 0 || compLevel > 9) {
            throw new PngjException("Compression level invalid (" + compLevel + ") Must be 0..9");
        }
        this.compLevel = compLevel;
    }

    public String getFilename() {
        return this.filename;
    }

    private void copyChunks(PngReader reader, int copy_mask, boolean onlyAfterIdat) {
        boolean idatDone = this.step.compareTo(WriteStep.IDAT) >= 0;
        int posidat = reader.chunks.positionIDAT();
        if (onlyAfterIdat && posidat < 0) {
            return;
        }
        List<PngChunk> chunksR = reader.chunks.getChunks();
        int i = 0;
        while (i < chunksR.size()) {
            if (i >= posidat || !onlyAfterIdat) {
                boolean copy = false;
                PngChunk chunk = chunksR.get(i);
                if (chunk.crit) {
                    if (chunk.id.equals("PLTE")) {
                        if (this.imgInfo.indexed && ChunksToWrite.maskMatch(copy_mask, 1)) {
                            copy = true;
                        }
                        if (!this.imgInfo.greyscale && ChunksToWrite.maskMatch(copy_mask, 8)) {
                            copy = true;
                        }
                    }
                } else {
                    boolean text = chunk instanceof PngChunkTextVar;
                    boolean safe = chunk.safe;
                    if (ChunksToWrite.maskMatch(copy_mask, 8)) {
                        copy = true;
                    }
                    if (safe && ChunksToWrite.maskMatch(copy_mask, 4)) {
                        copy = true;
                    }
                    if (chunk.id.equals("tRNS") && ChunksToWrite.maskMatch(copy_mask, 64)) {
                        copy = true;
                    }
                    if (chunk.id.equals("pHYs") && ChunksToWrite.maskMatch(copy_mask, 16)) {
                        copy = true;
                    }
                    if (text && ChunksToWrite.maskMatch(copy_mask, 32)) {
                        copy = true;
                    }
                }
                if (copy) {
                    if (chunk.beforeIDAT && idatDone) {
                        System.err.println("too late to add pre-idat chunk - " + chunk);
                    } else {
                        this.chunks.cloneAndAdd(chunk, false);
                    }
                }
            }
            ++i;
        }
    }

    public void copyChunksFirst(PngReader reader, int copy_mask) {
        this.copyChunks(reader, copy_mask, false);
    }

    public void copyChunksLast(PngReader reader, int copy_mask) {
        this.copyChunks(reader, copy_mask, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WriteStep {
        START,
        HEADER,
        HEADER_DONE,
        IDHR,
        IDHR_DONE,
        FIRST_CHUNKS,
        FIRST_CHUNKS_DONE,
        IDAT,
        IDAT_DONE,
        LAST_CHUNKS,
        LAST_CHUNKS_DONE,
        END;

    }
}

