/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractSampleHandler;
import ch.systemsx.cisd.openbis.etlserver.proteomics.IProtDAO;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Experiment;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Parameter;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

class AbundanceHandler
extends AbstractSampleHandler {
    private final SampleType sampleType = new SampleType();

    AbundanceHandler(IEncapsulatedOpenBISService openbisService, IProtDAO dao, ExperimentIdentifier experimentIdentifier, Experiment experiment, String delimiter, boolean restrictedSampleResolving) {
        super(openbisService, dao, experimentIdentifier, experiment, delimiter, restrictedSampleResolving);
        this.sampleType.setCode("SEARCH");
    }

    void addAbundancesToDatabase(Parameter parameter, long proteinID, String proteinName) {
        Sample sample = this.getOrCreateSample(parameter.getName(), proteinName);
        try {
            double abundance = Double.parseDouble(parameter.getValue());
            this.dao.createAbundance(proteinID, sample.getId(), abundance);
        }
        catch (NumberFormatException numberFormatException) {
            throw new UserFailureException("Abundance of sample '" + parameter.getName() + "' of protein '" + proteinName + "' is not a number: " + parameter.getValue());
        }
    }

    private Sample getOrCreateSample(String parameterName, String proteinName) {
        AbstractSampleHandler.SampleOrError sampleOrError = this.getOrCreateSampleOrError(parameterName);
        if (sampleOrError.error != null) {
            throw new UserFailureException("Protein '" + proteinName + "' has an abundance value for " + sampleOrError.error);
        }
        return sampleOrError.sample;
    }

    @Override
    protected void handleSample(String parameterName, ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample) {
        NewSample searchSample = new NewSample();
        searchSample.setSampleType(this.sampleType);
        SpaceIdentifier spaceIdentifier = new SpaceIdentifier(this.experimentIdentifier.getDatabaseInstanceCode(), this.experimentIdentifier.getSpaceCode());
        SampleIdentifier identifier = new SampleIdentifier(spaceIdentifier, String.valueOf(parameterName) + "_" + this.experimentIdentifier.getExperimentCode());
        searchSample.setIdentifier(identifier.toString());
        searchSample.setExperimentIdentifier(this.experimentIdentifier.toString());
        searchSample.setParentIdentifier(sample.getIdentifier());
        this.openbisService.registerSample(searchSample, null);
    }
}

