/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics.dto;

import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.AbstractDTOWithID;
import net.lemnik.eodsql.ResultColumn;

public class Sequence
extends AbstractDTOWithID {
    @ResultColumn(value="database_id")
    private long databaseID;
    @ResultColumn(value="protein_reference_id")
    private long proteinReferenceID;
    @ResultColumn(value="amino_acid_sequence")
    private String sequence;
    private String checksum;

    private Sequence() {
    }

    public Sequence(String sequence) {
        this.setSequence(sequence);
        this.calculateChecksum();
    }

    public final long getDatabaseID() {
        return this.databaseID;
    }

    public final void setDatabaseID(long databaseID) {
        this.databaseID = databaseID;
    }

    public final long getProteinReferenceID() {
        return this.proteinReferenceID;
    }

    public final void setProteinReferenceID(long proteinDescriptionID) {
        this.proteinReferenceID = proteinDescriptionID;
    }

    public final String getSequence() {
        return this.sequence;
    }

    public final void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public void calculateChecksum() {
        if (this.sequence != null) {
            this.setChecksum(Integer.toHexString(this.sequence.hashCode()));
        }
    }

    public final String getChecksum() {
        return this.checksum;
    }

    public final void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Sequence)) {
            return false;
        }
        return ((Sequence)obj).toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getDatabaseID()) + "-" + this.getProteinReferenceID() + ":" + this.sequence + "[" + this.checksum + "]";
    }
}

