/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.db;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.yeastx.db.DBUtils;
import ch.systemsx.cisd.yeastx.db.IDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.db.generic.DMGenericUtils;
import ch.systemsx.cisd.yeastx.db.generic.IDMGenericDAO;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;

public abstract class AbstractDatasetLoader<T extends IDMGenericDAO>
implements IDatasetLoader {
    protected boolean isTransactionCompleted = true;
    private final DataSource dataSource;
    private final Class<T> queryClass;
    private T daoOrNull;

    protected AbstractDatasetLoader(DataSource dataSource, Class<T> queryClass) {
        this.dataSource = dataSource;
        this.queryClass = queryClass;
    }

    protected AbstractDatasetLoader(DataSource dataSource, Class<T> queryClass, T dao) {
        this.dataSource = dataSource;
        this.queryClass = queryClass;
        this.daoOrNull = dao;
    }

    protected final T getDao() {
        if (this.daoOrNull == null) {
            this.daoOrNull = (IDMGenericDAO)DBUtils.getQuery(this.dataSource, this.queryClass);
        }
        return this.daoOrNull;
    }

    protected void createDataSet(DMDataSetDTO dataSet) {
        if (!this.isTransactionCompleted) {
            throw new IllegalStateException("The previous transaction of uploading a dataset has been neither commited nor rollbacked.");
        }
        DMGenericUtils.createDataSet(this.getDao(), dataSet);
        this.isTransactionCompleted = false;
    }

    protected void rollbackAndRethrow(Throwable exception) throws Error {
        try {
            this.rollback();
        }
        catch (DataAccessException dataAccessException) {}
        throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)exception);
    }

    @Override
    public void commit() {
        try {
            try {
                this.getDao().close(true);
            }
            catch (Throwable th) {
                this.rollbackAndRethrow(th);
                this.isTransactionCompleted = true;
            }
        }
        finally {
            this.isTransactionCompleted = true;
        }
    }

    @Override
    public void rollback() {
        this.isTransactionCompleted = true;
        DBUtils.rollbackAndClose(this.getDao());
    }
}

