/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.UnmodifiableListDecorator;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="projects", uniqueConstraints={@UniqueConstraint(columnNames={"code", "space_id"})})
@Friend(toClasses={ExperimentPE.class})
public final class ProjectPE
extends AttachmentHolderPE
implements Comparable<ProjectPE>,
IIdAndCodeHolder,
IModifierAndModificationDateBean,
Serializable {
    public static final ProjectPE[] EMPTY_ARRAY = new ProjectPE[0];
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private String permId;
    private SpacePE space;
    private List<ExperimentPE> experiments = new ArrayList<ExperimentPE>();
    private String code;
    private String description;
    private PersonPE projectLeader;
    private int size;
    private PersonPE registrator;
    private PersonPE modifier;
    private Date registrationDate;
    private ProjectIdentifier projectIdentifier;
    private Date modificationDate;
    private int version;

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @OptimisticLock(excluded=true)
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_modifier")
    public PersonPE getModifier() {
        return this.modifier;
    }

    @Override
    public void setModifier(PersonPE modifier) {
        this.modifier = modifier;
    }

    public final void setCode(String code) {
        this.code = code;
    }

    public final void setSpace(SpacePE space) {
        this.space = space;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Space can not be null.")
    @JoinColumn(name="space_id", updatable=true)
    @IndexedEmbedded(prefix="space ")
    public final SpacePE getSpace() {
        return this.space;
    }

    @OptimisticLock(excluded=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="projectInternal")
    @ContainedIn
    private List<ExperimentPE> getExperimentsInternal() {
        return this.experiments;
    }

    private void setExperimentsInternal(List<ExperimentPE> experiments) {
        this.experiments = experiments;
    }

    @Transient
    public List<ExperimentPE> getExperiments() {
        return new UnmodifiableListDecorator<ExperimentPE>(this.getExperimentsInternal());
    }

    public void setExperiments(List<ExperimentPE> experiments) {
        this.getExperimentsInternal().clear();
        for (ExperimentPE experiment : experiments) {
            this.addExperiment(experiment);
        }
    }

    @Private
    void addExperiment(ExperimentPE experiment) {
        ProjectPE project = experiment.getProject();
        if (project != null) {
            project.getExperimentsInternal().remove(experiment);
        }
        experiment.setProjectInternal(this);
        this.getExperimentsInternal().add(experiment);
    }

    @Transient
    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        this.size = size;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_leader", updatable=false)
    public final PersonPE getProjectLeader() {
        return this.projectLeader;
    }

    public final void setProjectLeader(PersonPE projectLeader) {
        this.projectLeader = projectLeader;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getSpace(), "space");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectPE)) {
            return false;
        }
        ProjectPE that = (ProjectPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getSpace(), (Object)that.getSpace());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getSpace());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("description", (Object)this.getDescription());
        return builder.toString();
    }

    @Override
    public final int compareTo(ProjectPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    @Override
    @SequenceGenerator(name="PROJECT_ID_SEQ", sequenceName="PROJECT_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    @Field(index=Index.TOKENIZED, store=Store.YES, name="perm_id")
    public String getPermId() {
        return this.permId;
    }

    @Override
    @Column(unique=true)
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public final String getCode() {
        return this.code;
    }

    @Override
    @Transient
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.PROJECT;
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="projectParentInternal", cascade={CascadeType.ALL}, orphanRemoval=true)
    @IndexedEmbedded(prefix="attachment ")
    @Fetch(value=FetchMode.SUBSELECT)
    protected Set<AttachmentPE> getInternalAttachments() {
        return this.attachments;
    }

    @Override
    @Transient
    public final String getIdentifier() {
        if (this.projectIdentifier == null) {
            this.projectIdentifier = IdentifierHelper.createProjectIdentifier(this);
        }
        return this.projectIdentifier.toString();
    }

    @Override
    @OptimisticLock(excluded=true)
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Version
    @Column(name="version", nullable=false)
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

