/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.test;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;

public class JavaCodeNormalizer {
    private JavaCodeNormalizer() {
    }

    public static String normalizeJavaCode(String javaCode) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        BufferedReader reader = new BufferedReader(new StringReader(javaCode));
        IState state = Code.FIRST_LINE;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                state = state.next(writer, line.trim());
            }
            String string = stringWriter.toString().trim();
            return string;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    private static final class Code
    implements IState {
        static final IState FIRST_LINE = new Code(true);
        static final IState LINE = new Code(false);
        private final boolean firstLine;

        Code(boolean firstLine) {
            this.firstLine = firstLine;
        }

        @Override
        public IState next(PrintWriter writer, String trimmedLine) {
            if (trimmedLine.length() == 0 || trimmedLine.startsWith("//")) {
                return FIRST_LINE;
            }
            if (trimmedLine.startsWith("/*")) {
                return trimmedLine.endsWith("*/") ? FIRST_LINE : Comment.INSTANCE;
            }
            if (this.firstLine) {
                writer.println();
            } else {
                writer.print(' ');
            }
            writer.print(this.removeInlineComment(trimmedLine));
            return LINE;
        }

        private String removeInlineComment(String trimmedLine) {
            int indexOfInlineComment = trimmedLine.indexOf("//");
            if (indexOfInlineComment < 0) {
                return trimmedLine;
            }
            return trimmedLine.substring(0, indexOfInlineComment).trim();
        }
    }

    private static final class Comment
    implements IState {
        static final IState INSTANCE = new Comment();

        private Comment() {
        }

        @Override
        public IState next(PrintWriter writer, String trimmedLine) {
            return trimmedLine.endsWith("*/") ? Code.FIRST_LINE : this;
        }
    }

    private static interface IState {
        public IState next(PrintWriter var1, String var2);
    }
}

