/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;

public class TableCellUtil {
    public static final String USER_PREFIX = "USER-";
    public static final String INTERN_PREFIX = "INTERN-";

    public static ISerializableComparable createTableCell(String token) {
        if (token == null) {
            return StringTableCell.EMPTY_CELL;
        }
        try {
            return new IntegerTableCell(Long.parseLong(token));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return new DoubleTableCell(Double.parseDouble(token));
            }
            catch (NumberFormatException numberFormatException2) {
                return new StringTableCell(token);
            }
        }
    }

    public static String getPropertyTypeCode(PropertyType propertyType) {
        return String.valueOf(propertyType.isInternalNamespace() ? INTERN_PREFIX : USER_PREFIX) + propertyType.getSimpleCode();
    }

    public static boolean isEditiableProperty(PropertyType propertyType) {
        DataTypeCode dataType = propertyType.getDataType().getCode();
        switch (dataType) {
            case INTEGER: 
            case VARCHAR: 
            case MULTILINE_VARCHAR: 
            case REAL: 
            case TIMESTAMP: 
            case BOOLEAN: 
            case CONTROLLEDVOCABULARY: 
            case MATERIAL: 
            case HYPERLINK: {
                return true;
            }
            case XML: {
                return false;
            }
        }
        throw new UnsupportedOperationException("");
    }

    private TableCellUtil() {
    }
}

