/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.io.ICloseable;
import ch.systemsx.cisd.base.io.ISynchronizable;
import ch.systemsx.cisd.common.collection.IExtendedBlockingQueue;
import ch.systemsx.cisd.common.io.IQueuePersister;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class PersistentExtendedBlockingQueueDecorator<E extends Serializable>
implements IExtendedBlockingQueue<E>,
ICloseable,
ISynchronizable {
    private final IExtendedBlockingQueue<E> delegate;
    private final IQueuePersister<E> persister;

    public PersistentExtendedBlockingQueueDecorator(IExtendedBlockingQueue<E> delegate, IQueuePersister<E> persister) {
        this.delegate = delegate;
        this.persister = persister;
    }

    @Override
    public void close() {
        this.persister.close();
    }

    @Override
    public void synchronize() {
        this.persister.sync();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public int remainingCapacity() {
        return this.delegate.remainingCapacity();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public E element() {
        return (E)((Serializable)this.delegate.element());
    }

    @Override
    public E peek() {
        return (E)((Serializable)this.delegate.peek());
    }

    @Override
    public E peekWait() throws InterruptedException {
        return (E)((Serializable)this.delegate.peekWait());
    }

    @Override
    public E peekWait(long timeout, TimeUnit unit) throws InterruptedException {
        return (E)((Serializable)this.delegate.peekWait(timeout, unit));
    }

    @Override
    public E poll() {
        this.persister.check();
        Serializable elementOrNull = (Serializable)this.delegate.poll();
        if (elementOrNull != null) {
            this.persister.removeFromHead(elementOrNull);
        }
        return (E)elementOrNull;
    }

    @Override
    public E remove() {
        this.persister.check();
        Serializable element = (Serializable)this.delegate.remove();
        this.persister.removeFromHead(element);
        return (E)element;
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.persister.check();
        Serializable elementOrNull = (Serializable)this.delegate.poll(timeout, unit);
        if (elementOrNull != null) {
            this.persister.removeFromHead(elementOrNull);
        }
        return (E)elementOrNull;
    }

    @Override
    public E take() throws InterruptedException {
        this.persister.check();
        Serializable element = (Serializable)this.delegate.take();
        this.persister.removeFromHead(element);
        return (E)element;
    }

    @Override
    public boolean add(E o) {
        this.persister.check();
        boolean ok = this.delegate.add(o);
        if (ok) {
            this.persister.addToTail(o);
        }
        return ok;
    }

    @Override
    public boolean offer(E o) {
        this.persister.check();
        boolean ok = this.delegate.offer(o);
        if (ok) {
            this.persister.addToTail(o);
        }
        return ok;
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        this.persister.check();
        boolean ok = this.delegate.offer(o, timeout, unit);
        if (ok) {
            this.persister.addToTail(o);
        }
        return ok;
    }

    @Override
    public void put(E o) throws InterruptedException {
        this.persister.check();
        this.delegate.put(o);
        this.persister.addToTail(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.persister.check();
        boolean ok = this.delegate.addAll(c);
        if (ok) {
            this.persister.persist();
        }
        return ok;
    }

    @Override
    public boolean remove(Object o) {
        this.persister.check();
        boolean ok = this.delegate.remove(o);
        if (ok) {
            this.persister.persist();
        }
        return ok;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.persister.check();
        boolean ok = this.delegate.removeAll(c);
        if (ok) {
            this.persister.persist();
        }
        return ok;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.persister.check();
        boolean ok = this.delegate.retainAll(c);
        if (ok) {
            this.persister.persist();
        }
        return ok;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        this.persister.check();
        int elementsDrained = this.delegate.drainTo(c, maxElements);
        if (elementsDrained > 0) {
            this.persister.persist();
        }
        return elementsDrained;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        this.persister.check();
        int elementsDrained = this.delegate.drainTo(c);
        if (elementsDrained > 0) {
            this.persister.persist();
        }
        return elementsDrained;
    }

    @Override
    public void clear() {
        this.persister.check();
        this.delegate.clear();
        this.persister.persist();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<E> delegateIterator;
            {
                this.delegateIterator = PersistentExtendedBlockingQueueDecorator.this.delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public E next() {
                return (Serializable)this.delegateIterator.next();
            }

            @Override
            public void remove() {
                PersistentExtendedBlockingQueueDecorator.this.persister.check();
                this.delegateIterator.remove();
                PersistentExtendedBlockingQueueDecorator.this.persister.persist();
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }
}

