/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.io.IQueuePersister;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.apache.log4j.Logger;

public class QueuePersister<E>
implements IQueuePersister<E> {
    private static final int MAX_RETRIES_ON_FAILURE = 3;
    private static final long MILLIS_TO_SLEEP_ON_FAILURE = 3000L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, QueuePersister.class);
    static final int QUEUE_IMPLEMENTATION_MARKER = -123456789;
    private static final int HEADER_LENGTH = 12;
    private static final int RECORD_HEADER_LENGTH = 4;
    private static final int MAX_SLICK = 100000;
    private final Queue<E> queue;
    private final File queueFile;
    private final File newQueueFile;
    private final boolean autoSync;
    private RandomAccessFile randomAccessFile;
    private int firstRecord = 12;
    private int lastRecord;

    public static <E> List<E> list(Class<E> clazz, File queueFile) {
        RandomAccessFile randomAccessFile;
        ArrayList result;
        block16: {
            List<E> list;
            block17: {
                File newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
                result = new ArrayList();
                randomAccessFile = null;
                randomAccessFile = !queueFile.exists() && newQueueFile.exists() ? new RandomAccessFile(newQueueFile, "r") : new RandomAccessFile(queueFile, "r");
                if (randomAccessFile.readInt() == -123456789) break block16;
                list = LegacyQueuePersister.list(clazz, queueFile);
                if (randomAccessFile == null) break block17;
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            return list;
        }
        try {
            try {
                int firstRecord = randomAccessFile.readInt();
                int lastRecord = randomAccessFile.readInt();
                QueuePersister.load(randomAccessFile, result, firstRecord, lastRecord);
            }
            catch (IOException iOException) {
                List list = Collections.emptyList();
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException2) {}
                }
                return list;
            }
        }
        catch (Throwable throwable) {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {}
        }
        return Collections.unmodifiableList(result);
    }

    public QueuePersister(Queue<E> queue, File queueFile) {
        this(queue, queueFile, false);
    }

    public QueuePersister(Queue<E> queue, File queueFile, boolean autoSync) {
        this.queue = queue;
        this.queueFile = queueFile;
        this.newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
        this.autoSync = autoSync;
        if (!queueFile.exists() && this.newQueueFile.exists() && !this.newQueueFile.renameTo(queueFile)) {
            throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + queueFile.getPath() + "'"));
        }
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws IOExceptionUnchecked {
        File file = this.queueFile;
        synchronized (file) {
            int i = 0;
            while (true) {
                try {
                    this.randomAccessFile = new RandomAccessFile(this.queueFile, "rw");
                    if (this.randomAccessFile.length() >= 4L && this.randomAccessFile.readInt() != -123456789) {
                        LegacyQueuePersister<E> oldPersister = new LegacyQueuePersister<E>(this.queue, this.queueFile);
                        oldPersister.close();
                        this.persist();
                        break;
                    }
                    if (this.randomAccessFile.length() < 12L) {
                        QueuePersister.writeFullHeader(this.randomAccessFile, this.firstRecord, this.lastRecord);
                    } else {
                        this.firstRecord = this.randomAccessFile.readInt();
                        if (this.firstRecord < 0) {
                            this.firstRecord = 12;
                        }
                        this.lastRecord = this.randomAccessFile.readInt();
                        if (this.lastRecord < 0) {
                            this.lastRecord = 0;
                        }
                    }
                    QueuePersister.load(this.randomAccessFile, this.queue, this.firstRecord, this.lastRecord);
                    if (this.firstRecord <= 0) break;
                    this.persist();
                }
                catch (IOException ex) {
                    operationLog.error((Object)String.format("Error opening queue file '%s', position %d, trying to re-open.", this.queueFile.getPath(), this.lastRecord), (Throwable)ex);
                    this.closeQuietly();
                    if (i == 3) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                    ConcurrencyUtilities.sleep(3000L);
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    private byte[] toByteArray(E o) {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oo = new ObjectOutputStream(ba);
            oo.writeObject(o);
            oo.close();
            return ba.toByteArray();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static Object objFromByteArray(byte[] data) {
        ByteArrayInputStream bi = new ByteArrayInputStream(data);
        try {
            ObjectInputStream oi = new ObjectInputStream(bi);
            return oi.readObject();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private void writeHeader() throws IOException {
        QueuePersister.writeFullHeader(this.randomAccessFile, this.firstRecord, this.lastRecord);
    }

    private static void writeFullHeader(RandomAccessFile raf, int firstRecord, int lastRecord) throws IOException {
        raf.seek(0L);
        raf.writeInt(-123456789);
        raf.writeInt(firstRecord);
        raf.writeInt(lastRecord);
    }

    private static <E> void load(RandomAccessFile randomAccessFile, Collection<E> collection, int firstRecord, int lastRecord) throws IOException {
        long pos = firstRecord;
        while (pos < (long)lastRecord) {
            randomAccessFile.seek(pos);
            int len = randomAccessFile.readInt();
            pos += (long)(len + 4);
            byte[] data = new byte[len];
            randomAccessFile.read(data, 0, len);
            QueuePersister.deserializeAndAdd(collection, data);
        }
    }

    private static <E> void deserializeAndAdd(Collection<E> collection, byte[] data) {
        collection.add(QueuePersister.objFromByteArray(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persist() {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.closeQuietly();
                this.fillNewQueueFile();
                if (!this.queueFile.delete()) {
                    throw new IOException("Cannot delete file '" + this.queueFile.getPath() + "'");
                }
                if (!this.newQueueFile.renameTo(this.queueFile)) {
                    throw new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + this.queueFile.getPath() + "'");
                }
                this.randomAccessFile = new RandomAccessFile(this.queueFile, "rw");
                if (this.autoSync) {
                    this.sync();
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private void fillNewQueueFile() throws IOException {
        RandomAccessFile newRandomAccessFile = null;
        try {
            newRandomAccessFile = new RandomAccessFile(this.newQueueFile, "rw");
            this.firstRecord = 12;
            this.lastRecord = -1;
            QueuePersister.writeFullHeader(newRandomAccessFile, this.firstRecord, this.lastRecord);
            int pos = 12;
            int elementSize = 0;
            for (Object elem : this.queue) {
                newRandomAccessFile.seek(pos += elementSize);
                byte[] data = this.toByteArray(elem);
                elementSize = data.length + 4;
                newRandomAccessFile.writeInt(data.length);
                newRandomAccessFile.write(data);
            }
            this.lastRecord = pos + elementSize;
            QueuePersister.writeFullHeader(newRandomAccessFile, this.firstRecord, this.lastRecord);
        }
        finally {
            if (newRandomAccessFile != null) {
                newRandomAccessFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToTail(E elem) {
        File file = this.queueFile;
        synchronized (file) {
            int i = 0;
            while (true) {
                try {
                    this.randomAccessFile.seek(this.lastRecord);
                    byte[] data = this.toByteArray(elem);
                    int elementSize = data.length + 4;
                    this.randomAccessFile.writeInt(data.length);
                    this.randomAccessFile.write(data);
                    this.lastRecord += elementSize;
                    this.writeHeader();
                    if (!this.autoSync) break;
                    this.sync();
                }
                catch (IOException ex) {
                    operationLog.error((Object)String.format("Error adding to tail of queue file '%s', position %d, trying to re-open.", this.queueFile.getPath(), this.lastRecord), (Throwable)ex);
                    this.closeQuietly();
                    if (i == 3) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                    ConcurrencyUtilities.sleep(3000L);
                    this.open();
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQuietly() {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException iOException) {
                operationLog.error((Object)String.format("Error on closing file '%s'", this.queueFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromHead(E elem) throws IOExceptionUnchecked {
        File file = this.queueFile;
        synchronized (file) {
            int i = 0;
            while (true) {
                try {
                    if (this.firstRecord > 100000) {
                        this.persist();
                        break;
                    }
                    this.randomAccessFile.seek(this.firstRecord);
                    this.firstRecord += this.randomAccessFile.readInt() + 4;
                    this.writeHeader();
                    if (!this.autoSync) break;
                    this.sync();
                }
                catch (IOException ex) {
                    operationLog.error((Object)String.format("Error removing from head of queue file '%s', position %d, trying to re-open.", this.queueFile.getPath(), this.lastRecord), (Throwable)ex);
                    this.closeQuietly();
                    if (i == 3) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                    }
                    ConcurrencyUtilities.sleep(3000L);
                    this.open();
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check() throws IllegalStateException {
        File file = this.queueFile;
        synchronized (file) {
            try {
                if (!this.randomAccessFile.getFD().valid() || !this.randomAccessFile.getChannel().isOpen()) {
                    this.randomAccessFile = new RandomAccessFile(this.queueFile, "rw");
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        File file = this.queueFile;
        synchronized (file) {
            try {
                this.randomAccessFile.getFD().sync();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    static class LegacyQueuePersister<E>
    implements IQueuePersister<E> {
        static final int DEFAULT_INITIAL_RECORD_SIZE = 32;
        private static final int LEGACY_HEADER_LENGTH = 12;
        private static final int LEGACY_RECORD_HEADER_LENGTH = 4;
        private static final int LEGACY_MAX_SLICK = 1000;
        private final Queue<E> queue;
        private final File queueFile;
        private final File newQueueFile;
        private final boolean autoSync;
        private int recordSize;
        private RandomAccessFile randomAccessFile;
        private int firstRecord;
        private int lastRecord;

        static <E> List<E> list(Class<E> clazz, File queueFile) {
            File newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
            ArrayList result = new ArrayList();
            RandomAccessFile randomAccessFile = null;
            try {
                try {
                    randomAccessFile = !queueFile.exists() && newQueueFile.exists() ? new RandomAccessFile(newQueueFile, "r") : new RandomAccessFile(queueFile, "r");
                    int firstRecord = randomAccessFile.readInt();
                    int lastRecord = randomAccessFile.readInt();
                    int recordSize = randomAccessFile.readInt();
                    LegacyQueuePersister.load(randomAccessFile, result, firstRecord, lastRecord, recordSize);
                }
                catch (IOException iOException) {
                    List list = Collections.emptyList();
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    return list;
                }
            }
            catch (Throwable throwable) {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            return Collections.unmodifiableList(result);
        }

        LegacyQueuePersister(Queue<E> queue, File queueFile) {
            this(queue, queueFile, 32, false);
        }

        LegacyQueuePersister(Queue<E> queue, File queueFile, int initialRecordSize, boolean autoSync) {
            this.queue = queue;
            this.queueFile = queueFile;
            this.newQueueFile = new File(queueFile.getParentFile(), String.valueOf(queueFile.getName()) + ".new");
            this.autoSync = autoSync;
            if (!queueFile.exists() && this.newQueueFile.exists() && !this.newQueueFile.renameTo(queueFile)) {
                throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + queueFile.getPath() + "'"));
            }
            try {
                this.randomAccessFile = new RandomAccessFile(queueFile, "rw");
                if (this.randomAccessFile.length() < 12L) {
                    this.recordSize = initialRecordSize;
                    LegacyQueuePersister.writeFullHeader(this.randomAccessFile, this.firstRecord, this.lastRecord, initialRecordSize);
                } else {
                    this.firstRecord = this.randomAccessFile.readInt();
                    if (this.firstRecord < 0) {
                        this.firstRecord = 0;
                    }
                    this.lastRecord = this.randomAccessFile.readInt();
                    if (this.lastRecord < 0) {
                        this.lastRecord = 0;
                    }
                    this.recordSize = this.randomAccessFile.readInt();
                    if (this.recordSize < 0) {
                        this.recordSize = 0;
                    }
                }
                LegacyQueuePersister.load(this.randomAccessFile, queue, this.firstRecord, this.lastRecord, this.recordSize);
                if (this.firstRecord > 0) {
                    this.persist();
                }
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        private byte[] toByteArray(E o) {
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oo = new ObjectOutputStream(ba);
                oo.writeObject(o);
                oo.close();
                return ba.toByteArray();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        private static Object objFromByteArray(byte[] data) {
            ByteArrayInputStream bi = new ByteArrayInputStream(data);
            try {
                ObjectInputStream oi = new ObjectInputStream(bi);
                return oi.readObject();
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        private void writeHeader() throws IOException {
            this.randomAccessFile.seek(0L);
            this.randomAccessFile.writeInt(this.firstRecord);
            this.randomAccessFile.writeInt(this.lastRecord);
        }

        private static void writeFullHeader(RandomAccessFile raf, int firstRecord, int lastRecord, int initialRecordSize) throws IOException {
            raf.seek(0L);
            raf.writeInt(firstRecord);
            raf.writeInt(lastRecord);
            raf.writeInt(initialRecordSize);
        }

        private static <E> void load(RandomAccessFile randomAccessFile, Collection<E> collection, int firstRecord, int lastRecord, int recordSize) {
            long pos = 12L + (long)recordSize * (long)firstRecord;
            int i = firstRecord;
            while (i < lastRecord) {
                try {
                    randomAccessFile.seek(pos);
                    pos += (long)recordSize;
                    int len = randomAccessFile.readInt();
                    byte[] data = new byte[len];
                    randomAccessFile.read(data, 0, len);
                    LegacyQueuePersister.deserializeAndAdd(collection, data);
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
                ++i;
            }
        }

        private static <E> void deserializeAndAdd(Collection<E> collection, byte[] data) {
            collection.add(LegacyQueuePersister.objFromByteArray(data));
        }

        private static int getNewRecordSize(int oldRecordSize, int elementSize) {
            return oldRecordSize < 1 ? elementSize : oldRecordSize * (elementSize / oldRecordSize + 1);
        }

        @Override
        public void persist() {
            this.primPersist(this.recordSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void primPersist(int newRecordSize) {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    this.randomAccessFile.close();
                    this.recordSize = this.fillNewQueueFile(newRecordSize);
                    if (!this.queueFile.delete()) {
                        throw new IOException("Cannot delete file '" + this.queueFile.getPath() + "'");
                    }
                    if (!this.newQueueFile.renameTo(this.queueFile)) {
                        throw new IOException("Cannot rename file '" + this.newQueueFile.getPath() + "' to '" + this.queueFile.getPath() + "'");
                    }
                    this.randomAccessFile = new RandomAccessFile(this.queueFile, "rw");
                    if (this.autoSync) {
                        this.sync();
                    }
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }

        private int fillNewQueueFile(int newRecordSize) throws IOException {
            RandomAccessFile newRandomAccessFile = null;
            try {
                newRandomAccessFile = new RandomAccessFile(this.newQueueFile, "rw");
                this.firstRecord = 0;
                this.lastRecord = this.queue.size();
                LegacyQueuePersister.writeFullHeader(newRandomAccessFile, this.firstRecord, this.lastRecord, newRecordSize);
                long pos = 12L;
                for (Object elem : this.queue) {
                    newRandomAccessFile.seek(pos);
                    pos += (long)newRecordSize;
                    byte[] data = this.toByteArray(elem);
                    int elementSize = data.length + 4;
                    if (elementSize > newRecordSize) {
                        newRandomAccessFile.close();
                        int n = this.fillNewQueueFile(LegacyQueuePersister.getNewRecordSize(newRecordSize, elementSize));
                        return n;
                    }
                    newRandomAccessFile.writeInt(data.length);
                    newRandomAccessFile.write(data);
                }
                int n = newRecordSize;
                return n;
            }
            finally {
                if (newRandomAccessFile != null) {
                    newRandomAccessFile.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addToTail(E elem) {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    long pos = 12L + (long)this.lastRecord * (long)this.recordSize;
                    this.randomAccessFile.seek(pos);
                    byte[] data = this.toByteArray(elem);
                    int elementSize = data.length + 4;
                    if (elementSize > this.recordSize) {
                        this.primPersist(LegacyQueuePersister.getNewRecordSize(this.recordSize, elementSize));
                        return;
                    }
                    this.randomAccessFile.writeInt(data.length);
                    this.randomAccessFile.write(data);
                    ++this.lastRecord;
                    this.writeHeader();
                    if (this.autoSync) {
                        this.sync();
                    }
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeFromHead(E elem) {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    if (this.firstRecord > 1000) {
                        this.persist();
                    } else {
                        ++this.firstRecord;
                        this.writeHeader();
                        if (this.autoSync) {
                            this.sync();
                        }
                    }
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void check() throws IllegalStateException {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    if (!this.randomAccessFile.getFD().valid()) {
                        throw new IllegalStateException("Cannot persist: file is closed.");
                    }
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    this.randomAccessFile.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() {
            File file = this.queueFile;
            synchronized (file) {
                try {
                    this.randomAccessFile.getFD().sync();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(ex);
                }
            }
        }
    }
}

