/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.logging;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public final class BufferedAppender
extends WriterAppender {
    private final ByteArrayOutputStream logRecorder = new ByteArrayOutputStream();

    public BufferedAppender() {
        this(Level.DEBUG);
    }

    public BufferedAppender(Level logLevel) {
        this(null, logLevel);
    }

    public BufferedAppender(String pattern, Level logLevel) {
        this(pattern, logLevel, null);
    }

    public BufferedAppender(String patternOrNull, Level logLevel, final String loggerNameSnippetToFilterOnOrNull) {
        if (loggerNameSnippetToFilterOnOrNull != null) {
            this.addFilter(new Filter(){

                public int decide(LoggingEvent event) {
                    String loggerName = event.getLoggerName();
                    return loggerName.indexOf(loggerNameSnippetToFilterOnOrNull) >= 0 ? 1 : -1;
                }
            });
        }
        this.setWriter(this.createWriter(this.logRecorder));
        this.setLayout(this.createLayout(patternOrNull));
        this.configureRootLogger();
        this.setThreshold((Priority)logLevel);
    }

    private final void configureRootLogger() {
        Logger.getRootLogger().addAppender((Appender)this);
    }

    protected Layout createLayout(String pattern) {
        return new PatternLayout(pattern);
    }

    public final String getLogContent() {
        return new String(this.logRecorder.toByteArray()).trim();
    }

    public List<String> getLogLines() {
        return Arrays.asList(this.getLogContent().split("\n"));
    }

    public final void resetLogContent() {
        this.logRecorder.reset();
    }

    public final void reset() {
        Logger.getRootLogger().removeAppender((Appender)this);
        super.reset();
    }

    public final String toString() {
        return this.getEncoding();
    }
}

