/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.string.StringUtilities;

public final class IndexOutOfBoundsException
extends ParserException {
    private static final String MESSAGE_FORMAT = "Not enough columns available. Looking for %s column but we have only %d columns (%s).";
    private static final long serialVersionUID = 1L;

    public IndexOutOfBoundsException(int index, String[] lineTokens) {
        super(IndexOutOfBoundsException.createMessage(index, lineTokens));
    }

    private static final String createMessage(int index, String[] lineTokens) {
        assert (lineTokens != null) : "Line tokens can not be null.";
        assert (index >= lineTokens.length) : "Index must be out of range (otherwise no reason to call this exception).";
        return String.format(MESSAGE_FORMAT, StringUtilities.getOrdinal(index + 1), lineTokens.length, CollectionUtils.abbreviate(lineTokens, -1, CollectionStyle.SINGLE_QUOTE_BOUNDARY));
    }
}

