/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.properties;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public final class PropertyUtils {
    static final String EMPTY_STRING_FORMAT = "Property '%s' is not specified.";
    static final String NON_BOOLEAN_VALUE_FORMAT = "Invalid boolean '%s'. Default value '%s' will be used.";
    static final String NON_CHAR_VALUE_FORMAT = "Invalid character '%s' (incorrect length). Default value '%s' will be used.";
    static final String NON_INT_VALUE_FORMAT = "Invalid integer '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_INT_VALUE_FORMAT = "Invalid positive integer '%s'. Default value '%s' will be used.";
    static final String NON_LONG_VALUE_FORMAT = "Invalid long '%s'. Default value '%s' will be used.";
    static final String NON_DOUBLE_VALUE_FORMAT = "Invalid double '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_LONG_VALUE_FORMAT = "Invalid positive long '%s'. Default value '%s' will be used.";
    static final String NOT_FOUND_PROPERTY_FORMAT = "Given key '%s' not found in properties '%s'";
    private static final String LIST_SEPARATOR = ",";

    private PropertyUtils() {
    }

    private static void assertParameters(Properties properties, String propertyKey) {
        assert (properties != null) : "Given properties can not be null.";
        assert (propertyKey != null) : "Given property key can not be null.";
    }

    public static final boolean hasProperty(Properties properties, String propertyKey) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String propOrNull = PropertyUtils.getProperty(properties, propertyKey);
        return propOrNull != null;
    }

    public static final String getProperty(Properties properties, String propertyKey) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = properties.getProperty(propertyKey);
        return StringUtils.isBlank((String)property) ? null : property.trim();
    }

    public static final String getPropertyKeepEmptyString(Properties properties, String propertyKey) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = properties.getProperty(propertyKey);
        return property == null ? null : property.trim();
    }

    public static final String getProperty(Properties properties, String propertyKey, String defaultValue) {
        String property = PropertyUtils.getProperty(properties, propertyKey);
        return property == null ? defaultValue : property;
    }

    public static final String getMandatoryProperty(Properties properties, String propertyKey) throws ConfigurationFailureException {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = PropertyUtils.getProperty(properties, propertyKey);
        if (property == null) {
            throw PropertyUtils.createPropertyNotFoundException(properties, propertyKey);
        }
        if (property.length() == 0) {
            throw ConfigurationFailureException.fromTemplate(EMPTY_STRING_FORMAT, propertyKey);
        }
        return property;
    }

    private static ConfigurationFailureException createPropertyNotFoundException(Properties properties, String propertyKey) {
        return ConfigurationFailureException.fromTemplate(NOT_FOUND_PROPERTY_FORMAT, propertyKey, CollectionUtils.abbreviate(Collections.list(properties.propertyNames()), 10));
    }

    public static final List<String> getMandatoryList(Properties properties, String propertyKey) {
        List<String> list = PropertyUtils.tryGetList(properties, propertyKey);
        if (list == null) {
            throw PropertyUtils.createPropertyNotFoundException(properties, propertyKey);
        }
        if (list.size() == 0) {
            throw ConfigurationFailureException.fromTemplate(EMPTY_STRING_FORMAT, propertyKey);
        }
        return list;
    }

    public static final List<String> tryGetList(Properties properties, String propertyKey) {
        String itemsList = PropertyUtils.getProperty(properties, propertyKey);
        if (itemsList == null) {
            return null;
        }
        String[] items = itemsList.split(LIST_SEPARATOR);
        int i = 0;
        while (i < items.length) {
            items[i] = items[i].trim().toUpperCase();
            ++i;
        }
        return Arrays.asList(items);
    }

    public static final List<String> tryGetListInOriginalCase(Properties properties, String propertyKey) {
        String itemsList = PropertyUtils.getProperty(properties, propertyKey);
        if (itemsList == null) {
            return null;
        }
        String[] items = itemsList.split(LIST_SEPARATOR);
        int i = 0;
        while (i < items.length) {
            items[i] = items[i].trim();
            ++i;
        }
        return Arrays.asList(items);
    }

    public static List<String> getList(Properties properties, String propertyKey) {
        ArrayList<String> result = new ArrayList<String>();
        String property = PropertyUtils.getProperty(properties, propertyKey);
        if (StringUtils.isNotBlank((String)property)) {
            String[] splittedProperty;
            String[] stringArray = splittedProperty = property.split(LIST_SEPARATOR);
            int n = splittedProperty.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                result.add(term.trim());
                ++n2;
            }
        }
        return result;
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String longOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)longOrNull).longValue();
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getLong(properties, propertyKey, defaultValue, null);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1L) : "Negative default value (< 0).";
        String longOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Long.parseLong(longOrNull);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getPosLong(properties, propertyKey, defaultValue, null);
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String intOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)intOrNull).intValue();
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getInt(properties, propertyKey, defaultValue, null);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1) : "Negative default value (< 0).";
        String intOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Integer.parseInt(intOrNull);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getPosInt(properties, propertyKey, defaultValue, null);
    }

    public static final double getDouble(Properties properties, String propertyKey, double defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String doubleOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (doubleOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)doubleOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_DOUBLE_VALUE_FORMAT, doubleOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Double.parseDouble(doubleOrNull);
    }

    public static final double getDouble(Properties properties, String propertyKey, double defaultValue) {
        return PropertyUtils.getDouble(properties, propertyKey, defaultValue, null);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String booleanOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (booleanOrNull == null) {
            return defaultValue;
        }
        Boolean bool = Boolean.getBoolean(booleanOrNull);
        if (bool == null) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_BOOLEAN_VALUE_FORMAT, booleanOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Boolean.toBoolean(bool);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue) {
        return PropertyUtils.getChar(properties, propertyKey, defaultValue, null);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String charOrNull = PropertyUtils.getProperty(properties, propertyKey);
        if (charOrNull == null) {
            return defaultValue;
        }
        if (charOrNull.length() != 1 && loggerOrNull != null) {
            loggerOrNull.log(LogLevel.INFO, String.format(NON_CHAR_VALUE_FORMAT, charOrNull, Character.valueOf(defaultValue)));
            return defaultValue;
        }
        return charOrNull.charAt(0);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue) {
        return PropertyUtils.getBoolean(properties, propertyKey, defaultValue, null);
    }

    public static final void trimProperties(Properties properties) {
        assert (properties != null) : "Unspecified properties";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            properties.setProperty(key, StringUtils.trim((String)properties.getProperty(key)));
        }
    }

    public static enum Boolean {
        TRUE("1", "yes", "true"),
        FALSE("0", "no", "false");

        private final String[] values;

        private Boolean(String ... values) {
            this.values = values;
        }

        public static final Boolean getBoolean(String value) {
            if (Boolean.contains(Boolean.TRUE.values, value)) {
                return TRUE;
            }
            if (Boolean.contains(Boolean.FALSE.values, value)) {
                return FALSE;
            }
            return null;
        }

        public final boolean toBoolean() {
            return Boolean.toBoolean(this);
        }

        public static final boolean toBoolean(Boolean bool) {
            return bool == TRUE;
        }

        private static final boolean contains(String[] values, String value) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equalsIgnoreCase(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

