/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.resource;

import ch.systemsx.cisd.common.collection.NullIterable;
import ch.systemsx.cisd.common.collection.NullIterator;
import ch.systemsx.cisd.common.resource.IReleasable;
import ch.systemsx.cisd.common.resource.ReleasableIterator;
import ch.systemsx.cisd.common.resource.Resources;
import java.util.Iterator;

public class ReleasableIterable<T>
implements Iterable<T>,
IReleasable {
    private Iterable<T> originalIterable;
    private Resources resources;

    public ReleasableIterable(Iterable<T> originalIterable) {
        if (originalIterable == null) {
            this.originalIterable = new NullIterable();
        } else {
            if (originalIterable instanceof IReleasable) {
                this.getResources().add(originalIterable);
            }
            this.originalIterable = originalIterable;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.originalIterable instanceof IReleasable) {
            return this.originalIterable.iterator();
        }
        Iterator<T> originalIterator = this.originalIterable.iterator();
        if (originalIterator != null) {
            if (originalIterator instanceof IReleasable) {
                this.getResources().add(originalIterator);
                return originalIterator;
            }
            ReleasableIterator<T> releasableIterator = new ReleasableIterator<T>(originalIterator);
            this.getResources().add(releasableIterator);
            return releasableIterator;
        }
        return new NullIterator();
    }

    @Override
    public void release() {
        if (this.resources != null) {
            this.resources.release();
        }
    }

    private Resources getResources() {
        if (this.resources == null) {
            this.resources = new Resources();
        }
        return this.resources;
    }
}

