/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.serviceconversation.client;

import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceConversationDTO;
import ch.systemsx.cisd.common.serviceconversation.client.ClientMessenger;
import ch.systemsx.cisd.common.serviceconversation.client.ClientResponseMessageMultiplexer;
import ch.systemsx.cisd.common.serviceconversation.client.ClientResponseMessageQueue;
import ch.systemsx.cisd.common.serviceconversation.client.IRemoteServiceConversationServer;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceConversation;

public class ServiceConversationClient {
    private final IRemoteServiceConversationServer server;
    private final IServiceMessageTransport transportToServer;
    private final ClientResponseMessageMultiplexer responseMessageMultiplexer = new ClientResponseMessageMultiplexer();

    public ServiceConversationClient(IRemoteServiceConversationServer server, IServiceMessageTransport transportToServer) {
        this.server = server;
        this.transportToServer = transportToServer;
    }

    public IServiceMessageTransport getIncomingResponseMessageTransport() {
        return this.responseMessageMultiplexer.getIncomingTransport();
    }

    public IServiceConversation startConversation(String typeId) {
        ClientResponseMessageQueue responseMessageQueue = new ClientResponseMessageQueue();
        ServiceConversationDTO serviceConversationRecord = this.server.startConversation(typeId);
        ClientMessenger clientMessenger = new ClientMessenger(serviceConversationRecord, this.transportToServer, responseMessageQueue, this.responseMessageMultiplexer);
        return clientMessenger;
    }
}

