/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

public class PropertyPlaceholderUtils {
    private static final String PLACEHOLDER_PREFIX = "${";

    public static final Integer getInteger(String value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith(PLACEHOLDER_PREFIX)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Incorrect integer property value: " + value, e);
        }
    }

    public static final Boolean getBoolean(String value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value.startsWith(PLACEHOLDER_PREFIX)) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Incorrect boolean property value: " + value);
    }
}

