/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.xml;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.xml.XMLInfraStructure;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class JaxbXmlParser<T> {
    private static final boolean DEBUG = false;
    private final Unmarshaller unmarshaller;
    private final Class<T> beanClass;

    public static <T> T parse(Class<T> beanClass, File dataSet, boolean validate) {
        JaxbXmlParser<T> parser = new JaxbXmlParser<T>(beanClass, validate);
        return parser.doParse(dataSet);
    }

    public JaxbXmlParser(Class<T> beanClass, boolean validate) {
        this.beanClass = beanClass;
        this.unmarshaller = JaxbXmlParser.createUnmarshaller(beanClass);
        if (validate) {
            this.unmarshaller.setSchema(XMLInfraStructure.createSchema("/" + beanClass.getPackage().getName().replace('.', '/') + "/schema.xsd"));
        }
    }

    private void useDebugValidationEventHandler() {
        try {
            this.unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
    }

    private static <T> Unmarshaller createUnmarshaller(Class<T> beanClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{beanClass});
            return context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
    }

    public static <T> void writeSchema(Class<T> beanClass) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{beanClass});
            JaxbXmlParser.debugGenerateXmlSchema(context);
        }
        catch (JAXBException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)ex));
        }
    }

    public static void debugGenerateXmlSchema(JAXBContext context) {
        try {
            context.generateSchema(new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String schemaName) throws IOException {
                    return new StreamResult(new File(".", schemaName));
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public T doParse(File file) {
        try {
            StreamSource source = new StreamSource(new FileInputStream(file));
            JAXBElement object = this.unmarshaller.unmarshal((Source)source, this.beanClass);
            return (T)object.getValue();
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }
}

