/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.mapping;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.common.JsonConstants;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.IJsonBaseTypeToSubTypesMapping;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class JsonReflectionsBaseTypeToSubTypesMapping
implements IJsonBaseTypeToSubTypesMapping {
    private static JsonReflectionsBaseTypeToSubTypesMapping instance;
    private Map<Class<?>, Set<NamedType>> baseTypeToSubTypesMap;
    private Set<NamedType> allSubTypesSet;

    public JsonReflectionsBaseTypeToSubTypesMapping(String prefix) {
        this.baseTypeToSubTypesMap = JsonReflectionsBaseTypeToSubTypesMapping.createBaseTypeToSubTypesMap(prefix);
        this.allSubTypesSet = JsonReflectionsBaseTypeToSubTypesMapping.createAllSubTypesSet(this.baseTypeToSubTypesMap);
    }

    @Override
    public Set<NamedType> getSubTypes(Class<?> baseType) {
        if (Object.class.equals(baseType)) {
            return this.allSubTypesSet;
        }
        return this.baseTypeToSubTypesMap.get(baseType);
    }

    private static Map<Class<?>, Set<NamedType>> createBaseTypeToSubTypesMap(String prefix) {
        Reflections reflections = new Reflections(prefix, new Scanner[0]);
        Set types = reflections.getTypesAnnotatedWith(JsonObject.class);
        HashMap subTypesMap = new HashMap();
        if (types != null) {
            for (Class baseType : types) {
                for (Class subType : types) {
                    if (!baseType.isAssignableFrom(subType)) continue;
                    HashSet<NamedType> subTypes = (HashSet<NamedType>)subTypesMap.get(baseType);
                    if (subTypes == null) {
                        subTypes = new HashSet<NamedType>();
                        subTypesMap.put(baseType, subTypes);
                    }
                    JsonObject subTypeAnnotation = subType.getAnnotation(JsonObject.class);
                    subTypes.add(new NamedType(subType, subTypeAnnotation.value()));
                }
            }
        }
        return subTypesMap;
    }

    private static Set<NamedType> createAllSubTypesSet(Map<Class<?>, Set<NamedType>> baseTypeToSubTypesMap) {
        HashSet<NamedType> allSubTypes = new HashSet<NamedType>();
        for (Set<NamedType> subTypes : baseTypeToSubTypesMap.values()) {
            allSubTypes.addAll(subTypes);
        }
        return allSubTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final JsonReflectionsBaseTypeToSubTypesMapping getInstance() {
        Class<JsonReflectionsBaseTypeToSubTypesMapping> clazz = JsonReflectionsBaseTypeToSubTypesMapping.class;
        synchronized (JsonReflectionsBaseTypeToSubTypesMapping.class) {
            if (instance == null) {
                instance = new JsonReflectionsBaseTypeToSubTypesMapping(JsonConstants.getClassesPrefix());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

