/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.progress;

import ch.systemsx.cisd.base.namedthread.NamingThreadFactory;
import ch.systemsx.cisd.common.serviceconversation.server.ProgressInfo;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServiceConversationAutomaticProgressListener
implements IServiceConversationProgressListener {
    private ScheduledThreadPoolExecutor executor;
    private ScheduledFuture<?> future;

    public ServiceConversationAutomaticProgressListener(final ServiceConversationServer server, final String conversationId, int reportingInterval, final Method method) {
        NamingThreadFactory threadFactory = new NamingThreadFactory(String.valueOf(Thread.currentThread().getName()) + "-automatic-progress-listener");
        threadFactory.setCreateDaemonThreads(true);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setThreadFactory(threadFactory);
        this.future = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                server.reportProgress(conversationId, new ProgressInfo("processing " + method.getDeclaringClass().getSimpleName() + "." + method.getName()));
            }
        }, 0L, reportingInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void update(String label, int totalItemsToProcess, int numItemsProcessed) {
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.future.cancel(false);
    }
}

