/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.types;

public enum BooleanOrUnknown {
    F("FALSE"),
    T("TRUE"),
    U("UNKNOWN");

    private final String niceRepresentation;

    private BooleanOrUnknown(String niceRepresentation) {
        this.niceRepresentation = niceRepresentation;
    }

    public final String getNiceRepresentation() {
        return this.niceRepresentation;
    }

    public static final BooleanOrUnknown resolve(String niceRepresentationOrNull) {
        if (niceRepresentationOrNull == null) {
            return U;
        }
        if (niceRepresentationOrNull.equals("FALSE")) {
            return F;
        }
        if (niceRepresentationOrNull.equals("TRUE")) {
            return T;
        }
        if (niceRepresentationOrNull.equals("UNKNOWN")) {
            return U;
        }
        throw new IllegalArgumentException(String.format("Given nice representation '%s' unknown.", niceRepresentationOrNull));
    }

    public static final BooleanOrUnknown resolve(boolean flag) {
        return flag ? T : F;
    }

    public static final Boolean tryToResolve(BooleanOrUnknown booleanOrUnknown) {
        return booleanOrUnknown == U ? null : Boolean.valueOf(booleanOrUnknown == T);
    }
}

