/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui.model;

import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.TransmissionSpeedCalculator;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadOperation;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DataSetUploadTableModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.DssCommunicationState;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IAsyncAction;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.IUserNotifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.Identifier;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.SamplesDataSets;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.UploadClientSortingUtils;
import ch.systemsx.cisd.openbis.dss.client.api.gui.model.ValidatedFile;
import ch.systemsx.cisd.openbis.dss.client.api.v1.DataSet;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IOpenbisServiceFacade;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTOBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.validation.ValidationError;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetTypeFilter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DataSetUploadClientModel {
    private static ExecutorService executor = new NamingThreadPoolExecutor("Data Set Upload", 1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()).daemonize();
    private final IOpenbisServiceFacade openBISService;
    private final ITimeProvider timeProvider;
    private List<DataSetType> dataSetTypes;
    private final ArrayList<NewDataSetInfo> newDataSetInfos = new ArrayList();
    private final LinkedList<ValidatedFile> userSelectedFiles = new LinkedList();
    private final SimplePropertyValidator simplePropertyValidator = new SimplePropertyValidator();
    private DataSetUploadTableModel tableModel;
    private final List<Observer> observers = new LinkedList<Observer>();
    private List<Vocabulary> vocabularies;
    private List<Project> projects;
    private List<Experiment> experiments;
    private List<String> projectIdentifiers;
    private List<SampleType> sampleTypes;
    private IUserNotifier userNotifier;

    public DataSetUploadClientModel(DssCommunicationState commState, ITimeProvider timeProvider, IUserNotifier userNotifier) {
        this.openBISService = commState.getOpenBISService();
        this.timeProvider = timeProvider;
        this.userNotifier = userNotifier;
        this.reloadDataFromServer();
    }

    public void reloadDataFromServer() {
        this.sampleTypes = this.openBISService.listSampleTypes();
        DataSetTypeFilter filter = new DataSetTypeFilter(System.getProperty("creatable-data-set-types-whitelist"), System.getProperty("creatable-data-set-types-blacklist"));
        this.dataSetTypes = filter.filterDataSetTypes(this.openBISService.listDataSetTypes());
        this.vocabularies = this.openBISService.listVocabularies();
        this.projects = this.openBISService.listProjects();
        ArrayList<String> projectIds = new ArrayList<String>();
        for (Project project : this.projects) {
            ProjectIdentifier id = new ProjectIdentifier(project.getSpaceCode(), project.getCode());
            projectIds.add(id.toString());
        }
        this.projectIdentifiers = projectIds;
        this.experiments = this.openBISService.listExperimentsForProjects(projectIds);
    }

    public List<NewDataSetInfo> getNewDataSetInfos() {
        return Collections.unmodifiableList(this.newDataSetInfos);
    }

    public NewDataSetInfo addNewDataSetInfo(NewDataSetInfo template) {
        NewDataSetDTOBuilder newDataSetBuilder = new NewDataSetDTOBuilder();
        if (template == null) {
            String defaultDataSetTypeCode = this.getDefaultDataSetTypeCode();
            newDataSetBuilder.getDataSetMetadata().setDataSetTypeOrNull(defaultDataSetTypeCode);
        } else {
            newDataSetBuilder.initializeFromTemplate(template.getNewDataSetBuilder());
        }
        NewDataSetInfo newDataSetInfo = new NewDataSetInfo(newDataSetBuilder, this.timeProvider);
        this.newDataSetInfos.add(newDataSetInfo);
        this.validateNewDataSetInfoAndNotifyObservers(newDataSetInfo);
        return newDataSetInfo;
    }

    private String getDefaultDataSetTypeCode() {
        if (this.dataSetTypes.size() > 0) {
            return this.getDataSetTypes().get(0).getCode();
        }
        return null;
    }

    public void removeNewDataSetInfo(NewDataSetInfo dataSetInfoToRemove) {
        this.newDataSetInfos.remove(dataSetInfoToRemove);
    }

    public IOpenbisServiceFacade getOpenBISService() {
        return this.openBISService;
    }

    public void listSamples(final Identifier identifier, final IAsyncAction<List<Sample>> action) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Sample> samples = new ArrayList<Sample>();
                    String permId = identifier.getPermId();
                    switch (identifier.getOwnerType()) {
                        case EXPERIMENT: {
                            DataSetUploadClientModel.this.loadListableSamples(samples, permId);
                            break;
                        }
                        case SAMPLE: {
                            DataSetUploadClientModel.this.loadSamplesLinkedToAnExperiment(samples, permId);
                        }
                    }
                    UploadClientSortingUtils.sortSamplesByIdentifier(samples);
                    action.performAction(samples);
                }
                catch (Throwable throwable) {
                    action.handleException(throwable);
                }
            }
        });
    }

    public void listSamplesDataSets(final Identifier identifier, final IAsyncAction<SamplesDataSets> action) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<Sample> samples = new ArrayList<Sample>();
                    ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
                    String permId = identifier.getPermId();
                    switch (identifier.getOwnerType()) {
                        case EXPERIMENT: {
                            DataSetUploadClientModel.this.loadListableSamples(samples, permId);
                            dataSets.addAll(DataSetUploadClientModel.this.openBISService.listDataSetsForExperiment(permId));
                            break;
                        }
                        case SAMPLE: {
                            DataSetUploadClientModel.this.loadSamplesLinkedToAnExperiment(samples, permId);
                            dataSets.addAll(DataSetUploadClientModel.this.openBISService.listDataSetsForSample(permId));
                        }
                    }
                    UploadClientSortingUtils.sortSamplesByIdentifier(samples);
                    UploadClientSortingUtils.sortDataSetsByCode(dataSets);
                    action.performAction(new SamplesDataSets(samples, dataSets));
                }
                catch (Throwable throwable) {
                    action.handleException(throwable);
                }
            }
        });
    }

    private void loadListableSamples(List<Sample> samples, String experimentPermId) {
        for (SampleType sampleType : this.sampleTypes) {
            if (!sampleType.isListable()) continue;
            samples.addAll(this.openBISService.listSamplesForExperimentAndSampleType(experimentPermId, sampleType.getCode()));
        }
    }

    private void loadSamplesLinkedToAnExperiment(List<Sample> samples, String samplePermId) {
        for (Sample sample : this.openBISService.listSamplesOfSample(samplePermId)) {
            if (sample.getExperimentIdentifierOrNull() == null) continue;
            samples.add(sample);
        }
    }

    private void execute(Runnable runnable) {
        new Thread(runnable).start();
    }

    public List<DataSetType> getDataSetTypes() {
        return this.dataSetTypes;
    }

    public DataSetType getDataSetType(String dataSetTypeCode) {
        for (DataSetType dataSetType : this.dataSetTypes) {
            if (!dataSetType.getCode().equals(dataSetTypeCode)) continue;
            return dataSetType;
        }
        return null;
    }

    public int getIndexOfDataSetType(String dataSetTypeCode) {
        if (dataSetTypeCode == null) {
            return 0;
        }
        int i = 0;
        while (i < this.dataSetTypes.size()) {
            if (this.dataSetTypes.get(i).getCode().equals(dataSetTypeCode)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public DataSetUploadTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(DataSetUploadTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void notifyObserversOfChanges(NewDataSetInfo changedInfo) {
        this.tableModel.selectedRowDataChanged();
    }

    public NewDataSetDTO cleanNewDataSetDTO(NewDataSetDTO newDataSetDTO) {
        DataSetType dataSetType = this.tryDataSetType(newDataSetDTO.tryDataSetType());
        if (dataSetType == null) {
            throw new UserFailureException("The new data set has no type");
        }
        HashSet<String> allPropertyCodes = new HashSet<String>();
        for (PropertyTypeGroup group : dataSetType.getPropertyTypeGroups()) {
            for (PropertyType propertyType : group.getPropertyTypes()) {
                allPropertyCodes.add(propertyType.getCode());
            }
        }
        HashSet<String> keys = new HashSet<String>(newDataSetDTO.getProperties().keySet());
        for (String propertyTypeCode : keys) {
            if (allPropertyCodes.contains(propertyTypeCode)) continue;
            newDataSetDTO.getProperties().remove(propertyTypeCode);
        }
        return newDataSetDTO;
    }

    public void queueUploadOfDataSet(NewDataSetInfo newDataSetInfo) {
        if (!newDataSetInfo.canBeQueued()) {
            return;
        }
        newDataSetInfo.setStatus(NewDataSetInfo.Status.QUEUED_FOR_UPLOAD);
        DataSetUploadOperation op = new DataSetUploadOperation(this.tableModel, this, newDataSetInfo, this.userNotifier);
        executor.submit(op);
    }

    public void queueUploadOfDataSet(List<NewDataSetInfo> newDataSetInfosToQueue) {
        for (NewDataSetInfo newDataSetInfo : newDataSetInfosToQueue) {
            this.queueUploadOfDataSet(newDataSetInfo);
        }
    }

    public void userDidSelectFile(ValidatedFile selectedFile) {
        this.userSelectedFiles.remove(selectedFile);
        this.userSelectedFiles.addFirst(selectedFile);
    }

    private DataSetType tryDataSetType(String dataSetTypeCode) {
        if (dataSetTypeCode == null) {
            return null;
        }
        int i = 0;
        while (i < this.dataSetTypes.size()) {
            DataSetType type = this.dataSetTypes.get(i);
            if (type.getCode().equals(dataSetTypeCode)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    public List<ValidatedFile> getUserSelectedFiles() {
        return this.userSelectedFiles;
    }

    public final void validateNewDataSetInfoAndNotifyObservers(NewDataSetInfo newDataSetInfo) {
        this.validateNewDataSetInfo(newDataSetInfo);
        this.notifyObserversOfChanges(newDataSetInfo);
    }

    private final void validateNewDataSetInfo(NewDataSetInfo newDataSetInfo) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        this.validateNewDataSetInfo(newDataSetInfo, errors);
        newDataSetInfo.setValidationErrors(errors);
    }

    protected void validateNewDataSetInfo(NewDataSetInfo newDataSetInfo, ArrayList<ValidationError> errors) {
        NewDataSetMetadataDTO builderMetadata;
        String typeCode;
        NewDataSetDTOBuilder builder = newDataSetInfo.getNewDataSetBuilder();
        String identifier = builder.getDataSetOwner().getIdentifier();
        if (identifier == null || identifier.trim().length() < 1) {
            errors.add(ValidationError.createOwnerValidationError("An owner must be specified."));
        }
        if (builder.getFile() == null) {
            errors.add(ValidationError.createFileValidationError("A file must be specified."));
        }
        if ((typeCode = (builderMetadata = builder.getDataSetMetadata()).tryDataSetType()) == null) {
            errors.add(ValidationError.createDataSetTypeValidationError("A data set type must be specified."));
        } else {
            DataSetType type = this.dataSetTypes.get(this.getIndexOfDataSetType(typeCode));
            Map<String, String> properties = builderMetadata.getProperties();
            for (PropertyTypeGroup ptGroup : type.getPropertyTypeGroups()) {
                for (PropertyType propertyType : ptGroup.getPropertyTypes()) {
                    this.validatePropertyType(propertyType, properties.get(propertyType.getCode()), errors);
                }
            }
        }
        if (errors.isEmpty()) {
            List<ValidationError> scriptDetectedErrors = this.openBISService.validateDataSet(builder.asNewDataSetDTO(), builder.getFile());
            errors.addAll(scriptDetectedErrors);
        }
    }

    protected void validatePropertyType(PropertyType propertyType, String valueOrNull, ArrayList<ValidationError> errors) {
        if (valueOrNull == null || valueOrNull.trim().length() < 1) {
            if (propertyType.isMandatory()) {
                errors.add(ValidationError.createPropertyValidationError(propertyType.getCode(), "A value must be provided."));
            }
            return;
        }
        try {
            DataTypeCode dataType = propertyType.getDataType();
            if (this.simplePropertyValidator.canValidate(dataType)) {
                this.simplePropertyValidator.validatePropertyValue(dataType, valueOrNull);
            }
        }
        catch (UserFailureException e) {
            errors.add(ValidationError.createPropertyValidationError(propertyType.getCode(), e.getMessage()));
        }
    }

    public void addUnofficialVocabularyTerm(Vocabulary vocabulary, String code, String label, String description, Long previousTermOrdinal) {
        NewVocabularyTerm term = this.createNewVocabularyTerm(code, label, description, previousTermOrdinal);
        this.openBISService.addAdHocVocabularyTerm(vocabulary.getId(), term);
        this.dataSetTypes = this.openBISService.listDataSetTypes();
        this.vocabularies = this.openBISService.listVocabularies();
        Vocabulary updatedVocabulary = this.getVocabulary(vocabulary.getCode());
        this.notifyObservers(updatedVocabulary, code);
    }

    private NewVocabularyTerm createNewVocabularyTerm(String code, String label, String description, Long previousTermOrdinal) {
        NewVocabularyTerm term = new NewVocabularyTerm();
        term.setCode(code);
        term.setLabel(label);
        term.setDescription(description);
        term.setPreviousTermOrdinal(previousTermOrdinal);
        return term;
    }

    public void registerObserver(Observer observer) {
        this.observers.add(observer);
    }

    private void notifyObservers(Vocabulary vocabulary, String code) {
        for (Observer observer : this.observers) {
            observer.update(vocabulary, code);
        }
    }

    public List<Experiment> getExperiments() {
        return Collections.unmodifiableList(this.experiments);
    }

    public List<String> getProjectIdentifiers() {
        return Collections.unmodifiableList(this.projectIdentifiers);
    }

    public Vocabulary getVocabulary(String code) {
        for (Vocabulary vocabulary : this.vocabularies) {
            if (!vocabulary.getCode().equals(code)) continue;
            return vocabulary;
        }
        return null;
    }

    public static class NewDataSetInfo {
        private final NewDataSetDTOBuilder newDataSetBuilder;
        private final TransmissionSpeedCalculator transmissionSpeedCalculator;
        private Status status;
        private long totalFileSize;
        private int percentageUploaded;
        private long numberOfBytesUploaded;
        private final ArrayList<ValidationError> validationErrors = new ArrayList();

        private NewDataSetInfo(NewDataSetDTOBuilder newDataSetBuilder, ITimeProvider timeProvider) {
            this.newDataSetBuilder = newDataSetBuilder;
            this.transmissionSpeedCalculator = new TransmissionSpeedCalculator(timeProvider);
            this.percentageUploaded = 0;
            this.numberOfBytesUploaded = 0L;
            this.setStatus(Status.TO_UPLOAD);
        }

        public NewDataSetDTOBuilder getNewDataSetBuilder() {
            return this.newDataSetBuilder;
        }

        public long getTotalFileSize() {
            return this.totalFileSize;
        }

        public int getPercentageDownloaded() {
            return this.percentageUploaded;
        }

        public long getNumberOfBytesDownloaded() {
            return this.numberOfBytesUploaded;
        }

        public long getEstimatedTimeOfArrival() {
            float remainingBytes = this.totalFileSize - this.numberOfBytesUploaded;
            float bytesPerMillisecond = this.transmissionSpeedCalculator.getEstimatedBytesPerMillisecond();
            if ((double)bytesPerMillisecond < 0.001) {
                return -1L;
            }
            return (long)(remainingBytes / bytesPerMillisecond);
        }

        void updateProgress(int percent, long numberOfBytes) {
            this.setStatus(Status.UPLOADING);
            int transmittedSinceLastUpdate = (int)(numberOfBytes - this.numberOfBytesUploaded);
            this.percentageUploaded = percent;
            this.numberOfBytesUploaded = numberOfBytes;
            this.transmissionSpeedCalculator.noteTransmittedBytesSinceLastUpdate(transmittedSinceLastUpdate);
        }

        public void setStatus(Status status) {
            this.status = status;
            if (Status.QUEUED_FOR_UPLOAD == status) {
                long size = 0L;
                for (FileInfoDssDTO fileInfo : this.newDataSetBuilder.getFileInfos()) {
                    if (fileInfo.getFileSize() <= 0L) continue;
                    size += fileInfo.getFileSize();
                }
                this.totalFileSize = size;
                this.percentageUploaded = 0;
                this.numberOfBytesUploaded = 0L;
            }
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean canBeQueued() {
            return this.status != Status.UPLOADING && this.status != Status.STALLED && this.status != Status.COMPLETED_UPLOAD && !this.hasErrors();
        }

        public boolean hasErrors() {
            return !this.validationErrors.isEmpty();
        }

        public List<ValidationError> getValidationErrors() {
            return this.validationErrors;
        }

        private void setValidationErrors(List<ValidationError> errors) {
            this.validationErrors.clear();
            this.validationErrors.addAll(errors);
        }

        public static enum Status {
            TO_UPLOAD,
            QUEUED_FOR_UPLOAD,
            UPLOADING,
            COMPLETED_UPLOAD,
            FAILED,
            STALLED;

        }
    }

    public static interface Observer {
        public void update(Vocabulary var1, String var2);
    }
}

