/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.v1.impl;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.dss.client.api.v1.impl.AbstractDssComponentState;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import org.springframework.remoting.RemoteConnectFailureException;

class UnauthenticatedState
extends AbstractDssComponentState {
    private String sessionTokenOrNull;

    UnauthenticatedState(IGeneralInformationService generalOpenBisService) {
        super(generalOpenBisService);
    }

    @Override
    public String getSessionToken() {
        if (this.sessionTokenOrNull == null) {
            throw new IllegalStateException("Please log in");
        }
        return this.sessionTokenOrNull;
    }

    @Override
    void login(String user, String password) throws AuthorizationFailureException, EnvironmentFailureException {
        try {
            this.sessionTokenOrNull = this.service.tryToAuthenticateForAllServices(user, password);
        }
        catch (RemoteConnectFailureException e) {
            throw new EnvironmentFailureException("Could not connect to server", e);
        }
        if (this.sessionTokenOrNull == null) {
            throw new AuthorizationFailureException("Login or Password invalid");
        }
    }

    @Override
    public void logout() {
    }
}

