/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.authentication.ILogMessagePrefixGenerator;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;

public final class LogMessagePrefixGenerator
implements ILogMessagePrefixGenerator<Session> {
    static final String UNDEFINED = "<UNDEFINED>";

    public String createPrefix(Session sessionOrNull) {
        SpacePE homeGroup;
        if (sessionOrNull == null) {
            return "[NO SESSION]";
        }
        String userName = sessionOrNull.getUserName();
        String groupCode = null;
        PersonPE person = sessionOrNull.tryGetPerson();
        if (person != null && (homeGroup = person.getHomeSpace()) != null) {
            groupCode = homeGroup.getCode();
        }
        String remoteHost = sessionOrNull.getRemoteHost();
        return this.createPrefix(userName, groupCode, remoteHost);
    }

    public String createPrefix(String user, String remoteHost) {
        return this.createPrefix(user, null, remoteHost);
    }

    private String createPrefix(String user, String groupCodeOrNull, String remoteHost) {
        return String.format("[USER:%s SPACE:%s HOST:%s]", this.cite(user), this.cite(groupCodeOrNull), this.cite(remoteHost));
    }

    private String cite(String text) {
        return text == null ? UNDEFINED : "'" + text + "'";
    }
}

