/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.openbis.common.api.client.IServicePinger;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;

public class OpenBisServiceFactory {
    private final String initialServerUrl;
    private final String urlServiceSuffix;

    public OpenBisServiceFactory(String serverUrl, String urlServiceSuffix) {
        this.initialServerUrl = serverUrl;
        this.urlServiceSuffix = urlServiceSuffix;
    }

    public IServiceForDataStoreServer createService() {
        return this.createServiceFinder().createService(IServiceForDataStoreServer.class, this.initialServerUrl, this.createServicePinger());
    }

    public IServiceForDataStoreServer createService(long timeoutInMillis) {
        return this.createServiceFinder().createService(IServiceForDataStoreServer.class, this.initialServerUrl, this.createServicePinger(), timeoutInMillis);
    }

    private ServiceFinder createServiceFinder() {
        return new ServiceFinder("openbis", this.urlServiceSuffix);
    }

    private IServicePinger<IServiceForDataStoreServer> createServicePinger() {
        return new IServicePinger<IServiceForDataStoreServer>(){

            @Override
            public void ping(IServiceForDataStoreServer service) {
                service.getVersion();
            }
        };
    }
}

