/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialTypeIdentifier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

@JsonObject(value="MaterialIdentifierGeneric")
public class MaterialIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MaterialTypeIdentifier materialTypeIdentifier;
    private String materialCode;

    public MaterialIdentifier(MaterialTypeIdentifier materialTypeIdentifier, String materialCode) {
        this.materialTypeIdentifier = materialTypeIdentifier;
        this.materialCode = materialCode;
    }

    public MaterialTypeIdentifier getMaterialTypeIdentifier() {
        return this.materialTypeIdentifier;
    }

    public String getMaterialCode() {
        return this.materialCode;
    }

    @JsonIgnore
    public String getAugmentedCode() {
        return String.valueOf(this.materialCode) + " (" + this.materialTypeIdentifier.getMaterialTypeCode() + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.materialCode == null ? 0 : this.materialCode.hashCode());
        result = 31 * result + (this.materialTypeIdentifier == null ? 0 : this.materialTypeIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterialIdentifier other = (MaterialIdentifier)obj;
        if (this.materialCode == null ? other.materialCode != null : !this.materialCode.equals(other.materialCode)) {
            return false;
        }
        return !(this.materialTypeIdentifier == null ? other.materialTypeIdentifier != null : !this.materialTypeIdentifier.equals(other.materialTypeIdentifier));
    }

    public String toString() {
        return "MaterialIdentifier [materialCode=" + this.materialCode + ", materialTypeIdentifier=" + this.materialTypeIdentifier + "]";
    }

    private MaterialIdentifier() {
    }

    private void setMaterialTypeIdentifier(MaterialTypeIdentifier materialTypeIdentifier) {
        this.materialTypeIdentifier = materialTypeIdentifier;
    }

    private void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
}

