/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RoleWithHierarchy
extends Enum<RoleWithHierarchy>
implements Serializable {
    public static final /* enum */ RoleWithHierarchy INSTANCE_DISABLED = new RoleWithHierarchy(true);
    public static final /* enum */ RoleWithHierarchy INSTANCE_ADMIN = new RoleWithHierarchy(new RoleWithHierarchy[0]);
    public static final /* enum */ RoleWithHierarchy INSTANCE_OBSERVER = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy INSTANCE_ETL_SERVER = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_ADMIN = new RoleWithHierarchy(INSTANCE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_POWER_USER = new RoleWithHierarchy(SPACE_ADMIN);
    public static final /* enum */ RoleWithHierarchy SPACE_USER = new RoleWithHierarchy(SPACE_POWER_USER);
    public static final /* enum */ RoleWithHierarchy SPACE_OBSERVER = new RoleWithHierarchy(SPACE_USER, INSTANCE_OBSERVER);
    public static final /* enum */ RoleWithHierarchy SPACE_ETL_SERVER = new RoleWithHierarchy(INSTANCE_ETL_SERVER);
    private static final String ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION = "Role doesn't match naming convention";
    private static final String SEPARATOR = "_";
    private final RoleCode roleCode;
    private final RoleLevel roleLevel;
    private final boolean completelyEmpty;
    private final Set<RoleWithHierarchy> strongerRoles = new LinkedHashSet<RoleWithHierarchy>();
    private static final /* synthetic */ RoleWithHierarchy[] ENUM$VALUES;

    static {
        ENUM$VALUES = new RoleWithHierarchy[]{INSTANCE_DISABLED, INSTANCE_ADMIN, INSTANCE_OBSERVER, INSTANCE_ETL_SERVER, SPACE_ADMIN, SPACE_POWER_USER, SPACE_USER, SPACE_OBSERVER, SPACE_ETL_SERVER};
    }

    public static RoleWithHierarchy valueOf(RoleLevel roleLevel, RoleCode roleCode) {
        return RoleWithHierarchy.valueOf(String.valueOf(roleLevel.name()) + SEPARATOR + roleCode.name());
    }

    private RoleWithHierarchy(boolean completelyEmpty) {
        this.completelyEmpty = completelyEmpty;
        this.roleLevel = RoleWithHierarchy.figureRoleLevel(this.name());
        this.roleCode = RoleWithHierarchy.figureRoleCode(this.name(), this.roleLevel);
    }

    private RoleWithHierarchy(RoleWithHierarchy ... strongerRoles) {
        this.completelyEmpty = false;
        this.roleLevel = RoleWithHierarchy.figureRoleLevel(this.name());
        this.roleCode = RoleWithHierarchy.figureRoleCode(this.name(), this.roleLevel);
        RoleWithHierarchy[] roleWithHierarchyArray = strongerRoles;
        int n2 = strongerRoles.length;
        int n3 = 0;
        while (n3 < n2) {
            RoleWithHierarchy strongerRole = roleWithHierarchyArray[n3];
            this.getStrongerRoles().add(strongerRole);
            for (RoleWithHierarchy role : strongerRole.getStrongerRoles()) {
                this.getStrongerRoles().add(role);
            }
            ++n3;
        }
    }

    private Set<RoleWithHierarchy> getStrongerRoles() {
        return this.strongerRoles;
    }

    static RoleLevel figureRoleLevel(String roleWithHierarchyName) {
        RoleLevel[] roleLevelArray = RoleLevel.values();
        int n = roleLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleLevel level = roleLevelArray[n2];
            if (roleWithHierarchyName.startsWith(String.valueOf(level.name()) + SEPARATOR)) {
                return level;
            }
            ++n2;
        }
        throw new IllegalArgumentException(ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION);
    }

    static RoleCode figureRoleCode(String roleWithHierarchyName, RoleLevel roleLevel) {
        assert (roleWithHierarchyName.startsWith(String.valueOf(roleLevel.name()) + SEPARATOR));
        RoleCode[] roleCodeArray = RoleCode.values();
        int n = roleCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleCode code = roleCodeArray[n2];
            if (code.name().equals(roleWithHierarchyName.substring(roleLevel.name().length() + 1))) {
                return code;
            }
            ++n2;
        }
        throw new IllegalArgumentException(ERROR_MSG_ROLE_DOESN_T_MATCH_NAMING_CONVENTION);
    }

    public Set<RoleWithHierarchy> getRoles() {
        LinkedHashSet<RoleWithHierarchy> roles = new LinkedHashSet<RoleWithHierarchy>();
        if (!this.completelyEmpty) {
            roles.add(this);
        }
        roles.addAll(this.strongerRoles);
        return roles;
    }

    public boolean isInstanceLevel() {
        return this.roleLevel.equals(RoleLevel.INSTANCE);
    }

    public boolean isSpaceLevel() {
        return this.roleLevel.equals(RoleLevel.SPACE);
    }

    public RoleLevel getRoleLevel() {
        return this.roleLevel;
    }

    public final RoleCode getRoleCode() {
        return this.roleCode;
    }

    public String toString() {
        return this.name();
    }

    public static RoleWithHierarchy[] values() {
        RoleWithHierarchy[] roleWithHierarchyArray = ENUM$VALUES;
        int n = roleWithHierarchyArray.length;
        RoleWithHierarchy[] roleWithHierarchyArray2 = new RoleWithHierarchy[n];
        System.arraycopy(ENUM$VALUES, 0, roleWithHierarchyArray2, 0, n);
        return roleWithHierarchyArray2;
    }

    public static RoleWithHierarchy valueOf(String string) {
        return Enum.valueOf(RoleWithHierarchy.class, string);
    }

    public static enum RoleCode implements IsSerializable
    {
        DISABLED,
        ADMIN,
        USER,
        POWER_USER,
        OBSERVER,
        ETL_SERVER;

    }

    public static enum RoleLevel implements IsSerializable
    {
        INSTANCE,
        SPACE;

    }
}

