/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISearchFieldCriterionFactory;

public class SearchFieldDateCriterionFactory
implements ISearchFieldCriterionFactory {
    @Override
    public DetailedSearchCriterion createCriterion(DetailedSearchField field, String value) {
        CompareType compareType;
        String code = field.getAttributeCode();
        if ("REGISTRATION_DATE_UNTIL".equals(code)) {
            compareType = CompareType.LESS_THAN_OR_EQUAL;
        } else if ("REGISTRATION_DATE".equals(code)) {
            compareType = CompareType.EQUALS;
        } else if ("REGISTRATION_DATE_FROM".equals(code)) {
            compareType = CompareType.MORE_THAN_OR_EQUAL;
        } else if ("MODIFICATION_DATE_UNTIL".equals(code)) {
            compareType = CompareType.LESS_THAN_OR_EQUAL;
        } else if ("MODIFICATION_DATE".equals(code)) {
            compareType = CompareType.EQUALS;
        } else if ("MODIFICATION_DATE_FROM".equals(code)) {
            compareType = CompareType.MORE_THAN_OR_EQUAL;
        } else {
            throw new IllegalArgumentException("Unknown date search field: " + code);
        }
        return new DetailedSearchCriterion(field, compareType, value);
    }
}

