/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentContentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import com.sun.org.apache.xerces.internal.impl.io.UTF8Reader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="attachments", uniqueConstraints={@UniqueConstraint(columnNames={"expe_id", "file_name", "version"}), @UniqueConstraint(columnNames={"samp_id", "file_name", "version"}), @UniqueConstraint(columnNames={"proj_id", "file_name", "version"})})
@ClassBridge(impl=AttachmentSearchBridge.class, index=Index.TOKENIZED, store=Store.NO)
public class AttachmentPE
extends HibernateAbstractRegistrationHolder
implements Serializable,
Comparable<AttachmentPE>,
IIdHolder {
    private static final long serialVersionUID = 35L;
    public static final AttachmentPE[] EMPTY_ARRAY = new AttachmentPE[0];
    private String fileName;
    private int version;
    private AttachmentContentPE attachmentContent;
    private transient Long id;
    private ExperimentPE experimentParent;
    private SamplePE sampleParent;
    private ProjectPE projectParent;
    private String description;
    private String title;

    @Column(name="file_name")
    @NotNull(message="File name can not be null.")
    @Length(max=255, message="Given file name '%s' is too long (maximal length: {max} characters).")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Column(name="version")
    @NotNull(message="Version can not be null.")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    @SequenceGenerator(name="ATTACHMENT_ID_SEQ", sequenceName="ATTACHMENT_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ATTACHMENT_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="expe_id", updatable=false)
    @ContainedIn
    @Private
    public ExperimentPE getExperimentParentInternal() {
        return this.experimentParent;
    }

    @Private
    public void setExperimentParentInternal(ExperimentPE parent) {
        this.experimentParent = parent;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @NotNull(message="The content of the attachment can not be null.")
    @JoinColumn(name="exac_id")
    public AttachmentContentPE getAttachmentContent() {
        return this.attachmentContent;
    }

    public void setAttachmentContent(AttachmentContentPE attachmentContent) {
        this.attachmentContent = attachmentContent;
    }

    @Column(name="title")
    @Length(max=100, message="Given title '%s' is too long (maximal length: {max} characters).")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getFileName(), "name");
        EqualsHashUtils.assertDefined(this.getVersion(), "version");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttachmentPE)) {
            return false;
        }
        AttachmentPE that = (AttachmentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getFileName(), (Object)that.getFileName());
        builder.append(this.getVersion(), that.getVersion());
        builder.append((Object)this.getParent(), (Object)that.getParent());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getFileName());
        builder.append(this.getVersion());
        builder.append((Object)this.getParent());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("fileName", (Object)this.getFileName());
        builder.append("version", this.getVersion());
        builder.append("parent", (Object)this.getParent());
        return builder.toString();
    }

    @Override
    public final int compareTo(AttachmentPE o) {
        int byFile = this.getFileName().compareTo(o.getFileName());
        return byFile == 0 ? Integer.valueOf(this.getVersion()).compareTo(o.getVersion()) : byFile;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="samp_id", updatable=false)
    @ContainedIn
    @Private
    public SamplePE getSampleParentInternal() {
        return this.sampleParent;
    }

    @Private
    public void setSampleParentInternal(SamplePE parent) {
        this.sampleParent = parent;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="proj_id", updatable=false)
    @ContainedIn
    @Private
    public ProjectPE getProjectParentInternal() {
        return this.projectParent;
    }

    @Private
    public void setProjectParentInternal(ProjectPE parent) {
        this.projectParent = parent;
    }

    @Transient
    public AttachmentHolderPE getParent() {
        if (this.getExperimentParentInternal() != null) {
            return this.getExperimentParentInternal();
        }
        if (this.getSampleParentInternal() != null) {
            return this.getSampleParentInternal();
        }
        if (this.getProjectParentInternal() != null) {
            return this.getProjectParentInternal();
        }
        return null;
    }

    public void setParent(AttachmentHolderPE owner) {
        if (owner instanceof ExperimentPE) {
            this.setExperimentParentInternal((ExperimentPE)owner);
        } else if (owner instanceof SamplePE) {
            this.setSampleParentInternal((SamplePE)owner);
        } else if (owner instanceof ProjectPE) {
            this.setProjectParentInternal((ProjectPE)owner);
        } else {
            throw new IllegalStateException("Unexpected attachment holder.");
        }
    }

    public static class AttachmentSearchBridge
    implements FieldBridge {
        private static final String SEARCHABLE_ATTACHMENT_MARKER = "[searchable]";

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            AttachmentPE attachment = (AttachmentPE)value;
            String attachmentName = attachment.getFileName();
            AttachmentSearchBridge.isSearchable(attachment);
            String attachmentNameFieldName = String.valueOf(name) + "'" + attachmentName + "' " + "name";
            document.add((Fieldable)AttachmentSearchBridge.createField(attachmentNameFieldName, attachmentName, luceneOptions));
            String attachmentTitleFieldName = String.valueOf(name) + "'" + attachmentName + "' " + "title";
            document.add((Fieldable)AttachmentSearchBridge.createField(attachmentTitleFieldName, attachment.getTitle(), luceneOptions));
            String attachmentDescriptionFieldName = String.valueOf(name) + "'" + attachmentName + "' " + "description";
            document.add((Fieldable)AttachmentSearchBridge.createField(attachmentDescriptionFieldName, attachment.getDescription(), luceneOptions));
        }

        private static Field createField(String name, String value, LuceneOptions luceneOptions) {
            return new Field(name, value == null ? "" : value, Field.Store.YES, luceneOptions.getIndex());
        }

        private static boolean isSearchable(AttachmentPE attachment) {
            String fileExt = FilenameUtils.getExtension((String)attachment.getFileName()).toLowerCase();
            if (fileExt.equals("txt") || fileExt.equals("pdf")) {
                return true;
            }
            String desc = attachment.getDescription();
            return StringUtils.isNotBlank((String)desc) && desc.startsWith(SEARCHABLE_ATTACHMENT_MARKER);
        }

        private void indexFileContent(Document document, LuceneOptions luceneOptions, AttachmentPE attachment, String attachmentName) {
            byte[] byteContent = attachment.getAttachmentContent().getValue();
            Reader reader = AttachmentSearchBridge.createAttachmentReader(byteContent);
            this.indexFileContent(document, luceneOptions, attachment, attachmentName, reader);
        }

        private static Reader createAttachmentReader(byte[] byteContent) {
            return new UTF8Reader(new ByteArrayInputStream(byteContent)){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    try {
                        return super.read(cbuf, off, len);
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
            };
        }

        private void indexFileContent(Document document, LuceneOptions luceneOptions, AttachmentPE attachment, String attachmentName, Reader contentReader) {
            String fieldName = "attachment '" + attachmentName + "', ver. " + attachment.getVersion();
            Field field = new Field(fieldName, contentReader);
            if (luceneOptions.getBoost() != null) {
                field.setBoost(luceneOptions.getBoost().floatValue());
            }
            document.add((Fieldable)field);
        }
    }
}

