/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.search.annotations.ContainedIn;

@Entity
@Table(name="material_properties", uniqueConstraints={@UniqueConstraint(columnNames={"mate_id", "mtpt_id"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class MaterialPropertyPE
extends EntityPropertyPE {
    private static final long serialVersionUID = 35L;
    public static final MaterialPropertyPE[] EMPTY_ARRAY = new MaterialPropertyPE[0];

    @Override
    @NotNull(message="Material type can not be null.")
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=MaterialTypePropertyTypePE.class)
    @JoinColumn(name="mtpt_id")
    public EntityTypePropertyTypePE getEntityTypePropertyType() {
        return this.entityTypePropertyType;
    }

    @Override
    @SequenceGenerator(name="MATERIAL_PROPERTY_ID_SEQ", sequenceName="MATERIAL_PROPERTY_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MATERIAL_PROPERTY_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    @Override
    @NotNull(message="Material can not be null.")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="mate_id")
    @ContainedIn
    public MaterialPE getEntity() {
        return (MaterialPE)this.entity;
    }
}

