/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.util.DisplaySettingsSerializationUtils;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.Type;

@Entity
@Table(name="persons")
public final class PersonDisplaySettingsPE
implements IIdHolder,
Serializable {
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private DisplaySettings displaySettings;
    private byte[] serializedDisplaySettings;

    @Override
    @Id
    public final Long getId() {
        return this.id;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @Transient
    public DisplaySettings getDisplaySettings() {
        if (this.displaySettings == null) {
            byte[] serializedSettings = this.getSerializedDisplaySettings();
            this.displaySettings = DisplaySettingsSerializationUtils.deserializeOrCreateDisplaySettings(serializedSettings);
        }
        return this.displaySettings;
    }

    public void setDisplaySettings(DisplaySettings displaySettings) {
        this.displaySettings = displaySettings;
        this.setSerializedDisplaySettings(DisplaySettingsSerializationUtils.serializeDisplaySettings(displaySettings));
    }

    @Transient
    public int getDisplaySettingsSize() {
        return this.serializedDisplaySettings == null ? 0 : this.serializedDisplaySettings.length;
    }

    @Column(name="display_settings", updatable=true)
    @Type(type="org.springframework.orm.hibernate3.support.BlobByteArrayType")
    private byte[] getSerializedDisplaySettings() {
        return this.serializedDisplaySettings;
    }

    private void setSerializedDisplaySettings(byte[] value) {
        this.serializedDisplaySettings = value;
    }
}

