/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedUiActionDescriptionFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescriptionFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ValidationException;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.SimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElementFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.ElementFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.JsonStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.XmlOrJsonStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.XmlStructuredPropertyConverter;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="managed-property-script-utility-factory")
public class ManagedPropertyFunctions {
    private static final IManagedInputWidgetDescriptionFactory INPUT_WIDGET_FACTORY_INSTANCE = new ManagedUiActionDescriptionFactory();
    private static final String ORIGINAL_COLUMN_NAME_BINDING_KEY_PREFIX = "$ORIGINAL-COLUMN-NAME$";
    private static final IElementFactory ELEMENT_FACTORY_INSTANCE = new ElementFactory();
    private static final XmlStructuredPropertyConverter XML_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE = new XmlStructuredPropertyConverter(ELEMENT_FACTORY_INSTANCE);
    private static final JsonStructuredPropertyConverter JSON_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE = new JsonStructuredPropertyConverter(ELEMENT_FACTORY_INSTANCE);
    private static final IStructuredPropertyConverter XML_STRUCTURED_PROPERTY_CONVERTER_INSTANCE = new XmlOrJsonStructuredPropertyConverter(XML_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE, JSON_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE, true);
    private static final IStructuredPropertyConverter JSON_STRUCTURED_PROPERTY_CONVERTER_INSTANCE = new XmlOrJsonStructuredPropertyConverter(XML_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE, JSON_ONLY_STRUCTURED_PROPERTY_CONVERTER_INSTANCE, false);
    private static IEntityInformationProvider entityInformationProvider;

    public IEntityInformationProvider getEntityInformationProvider() {
        return entityInformationProvider;
    }

    @Resource(name="entity-information-provider")
    public void setEntityInformationProvider(IEntityInformationProvider entityInformationProvider) {
        ManagedPropertyFunctions.entityInformationProvider = entityInformationProvider;
    }

    private ManagedPropertyFunctions() {
    }

    public static ISimpleTableModelBuilderAdaptor createTableBuilder() {
        return SimpleTableModelBuilderAdaptor.create(entityInformationProvider);
    }

    public static ValidationException ValidationException(String message) {
        return new ValidationException(message);
    }

    public static IManagedInputWidgetDescriptionFactory inputWidgetFactory() {
        return INPUT_WIDGET_FACTORY_INSTANCE;
    }

    public static IElementFactory elementFactory() {
        return ELEMENT_FACTORY_INSTANCE;
    }

    public static IStructuredPropertyConverter propertyConverter() {
        return XML_STRUCTURED_PROPERTY_CONVERTER_INSTANCE;
    }

    public static IStructuredPropertyConverter xmlPropertyConverter() {
        return XML_STRUCTURED_PROPERTY_CONVERTER_INSTANCE;
    }

    public static IStructuredPropertyConverter jsonPropertyConverter() {
        return JSON_STRUCTURED_PROPERTY_CONVERTER_INSTANCE;
    }

    public static IEntityInformationProvider entityInformationProvider() {
        return entityInformationProvider;
    }

    public static String originalColumnNameBindingKey(String originalColumnName) {
        return ORIGINAL_COLUMN_NAME_BINDING_KEY_PREFIX + originalColumnName;
    }

    public static boolean isOriginalColumnNameBindingKey(String bindingKey) {
        return bindingKey.startsWith(ORIGINAL_COLUMN_NAME_BINDING_KEY_PREFIX);
    }
}

