/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ExperimentTranslator {
    private ExperimentTranslator() {
    }

    private static void setProperties(ExperimentPE experiment, Experiment result, boolean rawManagedProperties, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        if (experiment.isPropertiesInitialized()) {
            if (rawManagedProperties) {
                result.setProperties(EntityPropertyTranslator.translateRaw(experiment.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
            } else {
                result.setProperties(EntityPropertyTranslator.translate(experiment.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
            }
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }

    public static final Experiment translateWithoutRevealingData(ExperimentPE experiment, Collection<Metaproject> metaprojects) {
        Experiment result = new Experiment(true);
        result.setId(HibernateUtils.getId(experiment));
        result.setPermId(experiment.getPermId());
        result.setProperties(new ArrayList<IEntityProperty>());
        result.setMetaprojects(metaprojects);
        return result;
    }

    public static final Experiment translateWithoutRevealingData(Experiment experiment) {
        Experiment result = new Experiment(true);
        result.setId(HibernateUtils.getId(experiment));
        result.setPermId(experiment.getPermId());
        result.setProperties(new ArrayList<IEntityProperty>());
        result.setMetaprojects(experiment.getMetaprojects());
        return result;
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, LoadableFields ... withFields) {
        return ExperimentTranslator.translate(experiment, baseIndexURL, false, metaprojects, managedPropertyEvaluatorFactory, withFields);
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, boolean rawManagedProperties, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, LoadableFields ... withFields) {
        if (experiment == null) {
            return null;
        }
        Experiment result = new Experiment();
        result.setId(HibernateUtils.getId(experiment));
        result.setModificationDate(experiment.getModificationDate());
        result.setCode(experiment.getCode());
        result.setPermId(experiment.getPermId());
        result.setPermlink(PermlinkUtilities.createPermlinkURL(baseIndexURL, EntityKind.EXPERIMENT, experiment.getPermId()));
        result.setExperimentType(ExperimentTranslator.translate(experiment.getExperimentType(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setIdentifier(experiment.getIdentifier());
        result.setProject(ProjectTranslator.translate(experiment.getProject()));
        result.setRegistrationDate(experiment.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(experiment.getRegistrator()));
        result.setModifier(PersonTranslator.translate(experiment.getModifier()));
        result.setDeletion(DeletionTranslator.translate(experiment.getDeletion()));
        result.setVersion(experiment.getVersion());
        LoadableFields[] loadableFieldsArray = withFields;
        int n = withFields.length;
        int n2 = 0;
        while (n2 < n) {
            LoadableFields field = loadableFieldsArray[n2];
            switch (field) {
                case PROPERTIES: {
                    ExperimentTranslator.setProperties(experiment, result, rawManagedProperties, managedPropertyEvaluatorFactory);
                    break;
                }
                case ATTACHMENTS: {
                    result.setAttachments(AttachmentTranslator.translate(experiment.getAttachments(), baseIndexURL));
                    break;
                }
            }
            ++n2;
        }
        if (metaprojects != null) {
            result.setMetaprojects(metaprojects);
        }
        return result;
    }

    public static final List<Experiment> translate(List<ExperimentPE> experiments, String baseIndexURL, Map<Long, Set<Metaproject>> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ArrayList<Experiment> result = new ArrayList<Experiment>(experiments.size());
        for (ExperimentPE experiment : experiments) {
            HibernateUtils.initialize(experiment.getProperties());
            result.add(ExperimentTranslator.translate(experiment, baseIndexURL, true, (Collection<Metaproject>)metaprojects.get(experiment.getId()), managedPropertyEvaluatorFactory, LoadableFields.PROPERTIES));
        }
        return result;
    }

    public static final ExperimentType translate(ExperimentTypePE experimentType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ExperimentType result = new ExperimentType();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(experimentType.getDatabaseInstance()));
        result.setModificationDate(experimentType.getModificationDate());
        result.setValidationScript(ScriptTranslator.translate(experimentType.getValidationScript()));
        result.setExperimentTypePropertyTypes(ExperimentTypePropertyTypeTranslator.translate(experimentType.getExperimentTypePropertyTypes(), result, cacheOrNull));
        return result;
    }

    public static final ExperimentTypePE translate(ExperimentType experimentType) {
        ExperimentTypePE result = new ExperimentTypePE();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(experimentType.getDatabaseInstance()));
        return result;
    }

    public static final List<ExperimentType> translate(List<ExperimentTypePE> experimentTypes) {
        ArrayList<ExperimentType> result = new ArrayList<ExperimentType>(experimentTypes.size());
        for (ExperimentTypePE experimentType : experimentTypes) {
            result.add(ExperimentTranslator.translate(experimentType, new HashMap<PropertyTypePE, PropertyType>()));
        }
        return result;
    }

    public static enum LoadableFields {
        ATTACHMENTS,
        PROPERTIES;

    }
}

