/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.IDatabaseInstanceFinder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.UuidUtil;

public class DatabaseInstanceIdentifierHelper {
    private DatabaseInstanceIdentifierHelper() {
    }

    public static final DatabaseInstancePE getDatabaseInstance(DatabaseInstanceIdentifier databaseInstanceIdentifier, IDatabaseInstanceFinder instanceFinder) throws UserFailureException {
        DatabaseInstancePE instancePE = DatabaseInstanceIdentifierHelper.tryGetDatabaseInstance(databaseInstanceIdentifier, instanceFinder);
        if (instancePE == null) {
            throw UserFailureException.fromTemplate("Database instance '%s' does not exist.", databaseInstanceIdentifier);
        }
        return instancePE;
    }

    public static final DatabaseInstancePE tryGetDatabaseInstance(DatabaseInstanceIdentifier databaseInstanceIdentifier, IDatabaseInstanceFinder instanceFinder) throws UserFailureException {
        if (databaseInstanceIdentifier.isHomeDatabase()) {
            return instanceFinder.getHomeDatabaseInstance();
        }
        String databaseInstanceCode = databaseInstanceIdentifier.getDatabaseInstanceCode();
        return DatabaseInstanceIdentifierHelper.tryGetDatabaseInstanceByCode(instanceFinder, databaseInstanceCode);
    }

    private static DatabaseInstancePE tryGetDatabaseInstanceByCode(IDatabaseInstanceFinder instanceFinder, String code) {
        boolean isUUID = UuidUtil.isValidUUID(code);
        if (isUUID) {
            return instanceFinder.tryFindDatabaseInstanceByUUID(code);
        }
        return instanceFinder.tryFindDatabaseInstanceByCode(code);
    }
}

