/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.installer.izpack.AbstractScriptExecutor;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;

public class ExecuteSetupScriptsAction
extends AbstractScriptExecutor
implements PanelAction {
    static final String DATA_SOURCES_KEY = "data-sources";
    static final String PATHINFO_DB_DATA_SOURCE = "path-info-db";
    static final String POST_REGISTRATION_TASKS_KEY = "post-registration.post-registration-tasks";
    static final String PATHINFO_DB_FEEDING_TASK = "pathinfo-feeding";
    static final String MAINTENANCE_PLUGINS_KEY = "maintenance-plugins";
    static final String PATHINFO_DB_DELETION_TASK = "path-info-deletion";
    static final String PROCESSING_PLUGINS_KEY = "processing-plugins";
    static final String PATHINFO_DB_CHECK = "path-info-db-consistency-check";
    private final String[] KEYS = new String[]{"data-sources", "post-registration.post-registration-tasks", "maintenance-plugins", "processing-plugins"};
    private final String[] TERMS = new String[]{"path-info-db", "pathinfo-feeding", "path-info-deletion", "path-info-db-consistency-check"};
    private final String[] CLASS_POSTFIX = new String[]{"version-holder-class", "class", "class", "class"};
    private static final String POST_INSTALLATION_SCRIPT = "post-installation.sh";
    private static final String RESTORE_CONFIG_FROM_BACKUP_SCRIPT = "restore-config-from-backup.sh";

    @Override
    public synchronized void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        if (GlobalInstallationContext.isFirstTimeInstallation) {
            this.executePostInstallationScript(data);
        } else {
            this.executRestoreConfigScript(data);
        }
        String keyStoreFileName = data.getVariable("KEY_STORE_FILE");
        String keyStorePassword = data.getVariable("KEY_STORE_PASSWORD");
        String certificatePassword = data.getVariable("KEY_PASSWORD");
        File installDir = GlobalInstallationContext.installDir;
        try {
            String pathinfoDBEnabled = data.getVariable("PATHINFO_DB_ENABLED");
            this.enablePathinfoDB(!"false".equalsIgnoreCase(pathinfoDBEnabled), installDir);
            this.installKeyStore(keyStoreFileName, installDir);
            this.injectPasswords(keyStorePassword, certificatePassword, installDir);
        }
        catch (Exception ex) {
            handler.emitErrorAndBlockNext("Fatal Error", ex.toString());
        }
    }

    void installKeyStore(String keyStoreFileName, File installDir) {
        if (keyStoreFileName != null && keyStoreFileName.length() > 0) {
            try {
                File keyStoreFile = new File(keyStoreFileName);
                if (Utils.isASInstalled(installDir)) {
                    File keystoreFileAS = Utils.getKeystoreFileForAS(installDir);
                    FileUtils.copyFile(keyStoreFile, keystoreFileAS);
                }
                File keystoreFileDSS = Utils.getKeystoreFileForDSS(installDir);
                FileUtils.copyFile(keyStoreFile, keystoreFileDSS);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    void enablePathinfoDB(boolean enableFlag, File installDir) {
        File dssServicePropertiesFile = new File(installDir, "servers/datastore_server/etc/service.properties");
        if (enableFlag) {
            int i = 0;
            while (i < this.KEYS.length) {
                String className;
                String key = this.KEYS[i];
                String newTerm = this.TERMS[i];
                String classProperty = String.valueOf(newTerm) + "." + this.CLASS_POSTFIX[i];
                int indexOfDot = key.indexOf(46);
                if (indexOfDot >= 0) {
                    classProperty = String.valueOf(key.substring(0, indexOfDot)) + "." + classProperty;
                }
                if ((className = Utils.tryToGetProperties(dssServicePropertiesFile).getProperty(classProperty)) != null) {
                    Utils.addTermToPropertyList(dssServicePropertiesFile, key, newTerm);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.KEYS.length) {
                Utils.removeTermFromPropertyList(dssServicePropertiesFile, this.KEYS[i], this.TERMS[i]);
                ++i;
            }
        }
    }

    void injectPasswords(String keyStorePassword, String keyPassword, File installDir) {
        File dssServicePropertiesFile = new File(installDir, "servers/datastore_server/etc/service.properties");
        Utils.updateOrAppendProperty(dssServicePropertiesFile, "keystore.password", keyStorePassword);
        Utils.updateOrAppendProperty(dssServicePropertiesFile, "keystore.key-password", keyPassword);
        if (Utils.isASInstalled(installDir)) {
            File jettyXMLFile = new File(installDir, "servers/openBIS-server/jetty/etc/jetty.xml");
            try {
                String jettyXML = FileUtils.readFileToString(jettyXMLFile);
                jettyXML = jettyXML.replaceAll("<Set name=\"Password\">.*</Set>", "<Set name=\"Password\"><![CDATA[" + keyStorePassword + "]]></Set>").replaceAll("<Set name=\"KeyPassword\">.*</Set>", "<Set name=\"KeyPassword\"><![CDATA[" + keyPassword + "]]></Set>");
                FileUtils.writeStringToFile(jettyXMLFile, jettyXML);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private void executRestoreConfigScript(AutomatedInstallData data) {
        String script = this.getAdminScript(data, RESTORE_CONFIG_FROM_BACKUP_SCRIPT);
        String backupConfigFolder = String.valueOf(data.getVariable("BACKUP_FOLDER")) + "/config-backup";
        this.executeAdminScript(null, script, backupConfigFolder);
    }

    private void executePostInstallationScript(AutomatedInstallData data) {
        String script = this.getAdminScript(data, POST_INSTALLATION_SCRIPT);
        HashMap<String, String> customEnvironment = new HashMap<String, String>();
        customEnvironment.put("ADMIN_PASSWORD", data.getVariable("ADMIN_PASSWORD"));
        customEnvironment.put("ETLSERVER_PASSWORD", data.getVariable("ETLSERVER_PASSWORD"));
        this.executeAdminScript(customEnvironment, script);
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }
}

