/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fileconverter;

import ch.systemsx.cisd.common.fileconverter.AbstractImageMagickConvertImageFileConverter;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class ImageMagickTiffToPngConverter
extends AbstractImageMagickConvertImageFileConverter {
    private final String transparentColorOrNull;
    private final int page;

    public ImageMagickTiffToPngConverter(String transparentColorOrNull, int page) {
        super(LogFactory.getLogger(LogCategory.MACHINE, ImageMagickTiffToPngConverter.class), LogFactory.getLogger(LogCategory.OPERATION, ImageMagickTiffToPngConverter.class));
        this.transparentColorOrNull = transparentColorOrNull;
        this.page = page;
    }

    @Override
    protected List<String> getCommandLine(File inFile, File outFile) {
        if (StringUtils.isNotEmpty(this.transparentColorOrNull)) {
            return Arrays.asList("-transparent", this.transparentColorOrNull, String.valueOf(inFile.getAbsolutePath()) + "[" + this.page + "]", outFile.getAbsolutePath());
        }
        return Arrays.asList(String.valueOf(inFile.getAbsolutePath()) + "[" + this.page + "]", outFile.getAbsolutePath());
    }
}

