/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.time;

import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;

public final class DateTimeUtils {
    private static final Pattern secPattern = Pattern.compile("([0-9]+)\\s*(|s|sec)");
    private static final Pattern minPattern = Pattern.compile("([0-9]+) *(m|min)");
    private static final Pattern hourPattern = Pattern.compile("([0-9]+) *(h|hours)");
    private static final Pattern dayPattern = Pattern.compile("([0-9]+) *(d|days)");
    private static final Pattern milliPattern = Pattern.compile("([0-9]+) *(ms|msec)");

    public static final String getTimeZone(Date date) {
        assert (date != null) : "Unspecified date.";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer zoneString = new StringBuffer();
        int value = calendar.get(15) + calendar.get(16);
        if (value < 0) {
            zoneString.append('-');
            value = -value;
        } else {
            zoneString.append('+');
        }
        int num = value / 3600000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        zoneString.append(":");
        num = value % 3600000 / 60000;
        zoneString.append(DateTimeUtils.prependZeroIfNeeded(num));
        return "GMT" + zoneString.toString();
    }

    private static final String prependZeroIfNeeded(int num) {
        return num < 10 ? "0" + num : "" + num;
    }

    public static String renderDuration(long durationInMillisecondsOrNeg) {
        if (durationInMillisecondsOrNeg < 0L) {
            return "?";
        }
        if (durationInMillisecondsOrNeg < 1000L) {
            return DateTimeUtils.render(1L, "sec");
        }
        long durationInSeconds = (durationInMillisecondsOrNeg + 500L) / 1000L;
        if (durationInSeconds < 100L) {
            return DateTimeUtils.render(durationInSeconds, "sec");
        }
        long durationInMinutes = (durationInSeconds + 30L) / 60L;
        if (durationInMinutes < 60L) {
            return DateTimeUtils.render(durationInMinutes, "min");
        }
        long minutes = durationInMinutes % 60L;
        long hours = durationInMinutes / 60L;
        if (minutes > 0L) {
            return String.valueOf(DateTimeUtils.render(hours, "h")) + " " + DateTimeUtils.render(minutes, "min");
        }
        return DateTimeUtils.render(hours, "h");
    }

    private static String render(long value, String unit) {
        return String.valueOf(value) + unit;
    }

    public static long getDurationInMillis(Properties properties, String key, long defaultValue) {
        String value = properties.getProperty(key);
        return value == null ? defaultValue : DateTimeUtils.parseDurationToMillis(value);
    }

    public static long parseDurationToMillis(String durationStr) {
        String durationStrTrimmed = durationStr.trim();
        Matcher m = secPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1)) * 1000L;
        }
        m = minPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1)) * 60L * 1000L;
        }
        m = hourPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1)) * 3600L * 1000L;
        }
        m = dayPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1)) * 24L * 3600L * 1000L;
        }
        m = dayPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1)) * 24L * 3600L * 1000L;
        }
        m = milliPattern.matcher(durationStrTrimmed);
        if (m.matches()) {
            return Long.parseLong(m.group(1));
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid duration", durationStrTrimmed));
    }

    public static Date extendUntilEndOfDay(Date date) {
        return DateUtils.addMilliseconds(DateUtils.addDays(DateUtils.truncate(date, 5), 1), -1);
    }
}

