/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.util.JsonPropertyUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

@JsonObject(value="Metaproject")
public class Metaproject
implements Serializable,
IIdAndCodeHolder,
IMetaprojectRegistration,
IMetaprojectUpdates {
    private static final long serialVersionUID = 35L;
    private Long id;
    private String name;
    private String description;
    private String ownerId;
    private boolean isPrivate;
    private Date creationDate;

    @Override
    @JsonIgnore
    public Long getId() {
        return this.id;
    }

    @JsonIgnore
    public void setId(Long id) {
        this.id = id;
    }

    public String getIdentifier() {
        return new MetaprojectIdentifier(this.ownerId, this.name).format();
    }

    public void setIdentifier(String identifier) {
        MetaprojectIdentifier identifierObject = MetaprojectIdentifier.parse(identifier);
        if (identifierObject != null) {
            this.ownerId = identifierObject.getMetaprojectOwnerId();
            this.name = identifierObject.getMetaprojectName();
        } else {
            this.ownerId = null;
            this.name = null;
        }
    }

    @Override
    @JsonIgnore
    public String getCode() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public static long getSerialversionuid() {
        return 35L;
    }

    @JsonProperty(value="id")
    private String getIdAsString() {
        return JsonPropertyUtil.toStringOrNull(this.id);
    }

    private void setIdAsString(String id) {
        this.id = JsonPropertyUtil.toLongOrNull(id);
    }
}

