/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;

public final class DatabaseInstanceTranslator {
    private DatabaseInstanceTranslator() {
    }

    public static final DatabaseInstance translate(DatabaseInstancePE databaseInstance) {
        if (databaseInstance == null) {
            return null;
        }
        DatabaseInstance result = new DatabaseInstance();
        result.setId(HibernateUtils.getId(databaseInstance));
        result.setCode(databaseInstance.getCode());
        result.setUuid(databaseInstance.getUuid());
        result.setHomeDatabase(databaseInstance.isOriginalSource());
        result.setIdentifier(IdentifierHelper.createDatabaseInstanceIdentifier(databaseInstance).toString());
        return result;
    }

    public static final DatabaseInstancePE translate(DatabaseInstance databaseInstance) {
        if (databaseInstance == null) {
            return null;
        }
        DatabaseInstancePE result = new DatabaseInstancePE();
        result.setCode(databaseInstance.getCode());
        result.setUuid(databaseInstance.getUuid());
        return result;
    }
}

