/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.plugins.AbstractDataSetDeletionPostProcessingMaintenanceTask;
import ch.systemsx.cisd.openbis.dss.generic.shared.IArchiverPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DeleteFromArchiveMaintenanceTask
extends AbstractDataSetDeletionPostProcessingMaintenanceTask {
    private static final String STATUS_FILENAME = "status-filename";
    private File lastSeenEventIdFile;

    @Override
    public void setUp(String pluginName, Properties properties) {
        super.setUp(pluginName, properties);
        String eventIdFileName = PropertyUtils.getMandatoryProperty(properties, STATUS_FILENAME);
        this.lastSeenEventIdFile = new File(eventIdFileName);
    }

    @Override
    protected void execute(List<DeletedDataSet> list) {
        List<DeletedDataSet> datasets = list;
        if (!this.lastSeenEventIdFile.exists()) {
            datasets = this.filterOldStyleHistoryEvents(list);
        }
        IArchiverPlugin archiverPlugin = ServiceProvider.getDataStoreService().getArchiverPlugin();
        List<DatasetLocation> datasetLocations = this.toDataSetLocations(datasets);
        archiverPlugin.deleteFromArchive(datasetLocations);
        String logMessage = String.format("Deleted %s dataset from archive: '%s'", datasets.size(), CollectionUtils.abbreviate(datasets, 10));
        operationLog.info(logMessage);
    }

    @Override
    protected Long getLastSeenEventId() {
        Long result;
        block3: {
            result = null;
            if (this.lastSeenEventIdFile.exists()) {
                try {
                    String statusFileContent = FileUtilities.loadToString(this.lastSeenEventIdFile);
                    statusFileContent = statusFileContent.trim();
                    result = Long.parseLong(statusFileContent);
                }
                catch (Exception ex) {
                    if (!operationLog.isDebugEnabled()) break block3;
                    operationLog.debug("Cannot load last seen event id from file :" + this.lastSeenEventIdFile, ex);
                }
            }
        }
        return result;
    }

    @Override
    protected void updateLastSeenEventId(Long newLastSeenEventId) {
        try {
            File tmpFile = File.createTempFile(this.lastSeenEventIdFile.getName(), "tmp", this.lastSeenEventIdFile.getParentFile());
            String fileContent = String.valueOf(newLastSeenEventId);
            FileUtilities.writeToFile(tmpFile, fileContent);
            tmpFile.renameTo(this.lastSeenEventIdFile);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private List<DeletedDataSet> filterOldStyleHistoryEvents(List<DeletedDataSet> datasets) {
        ArrayList<DeletedDataSet> result = new ArrayList<DeletedDataSet>();
        for (DeletedDataSet dataset : datasets) {
            if (dataset.getIdentifier() == null || dataset.getIdentifier().equals(dataset.getLocationOrNull())) continue;
            result.add(dataset);
        }
        return result;
    }

    private List<DatasetLocation> toDataSetLocations(List<DeletedDataSet> datasets) {
        ArrayList<DatasetLocation> result = new ArrayList<DatasetLocation>(datasets.size());
        for (DeletedDataSet deletedDS : datasets) {
            if (deletedDS.getLocationOrNull() == null) continue;
            result.add(this.toDataSetLocations(deletedDS));
        }
        return result;
    }

    private DatasetLocation toDataSetLocations(DeletedDataSet deletedDS) {
        DatasetLocation dsLocation = new DatasetLocation();
        dsLocation.setDatasetCode(deletedDS.getIdentifier());
        dsLocation.setDataSetLocation(deletedDS.getLocationOrNull());
        return dsLocation;
    }
}

