/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ZipDataSetPackager
extends AbstractDataSetPackager {
    private final File zipFile;
    private final boolean compress;
    private ZipOutputStream zipOutputStream;

    public ZipDataSetPackager(File zipFile, boolean compress, IHierarchicalContentProvider contentProvider, DataSetExistenceChecker dataSetExistenceChecker) {
        super(contentProvider, dataSetExistenceChecker);
        this.zipFile = zipFile;
        this.compress = compress;
    }

    @Override
    protected boolean isChecksumNeeded() {
        return !this.compress;
    }

    @Override
    public void addEntry(String entryPath, long lastModified, long size, long checksum, InputStream in) {
        ZipOutputStream zos = this.getZipOutputStream();
        try {
            try {
                int len;
                ZipEntry zipEntry = new ZipEntry(entryPath.replace('\\', '/'));
                zipEntry.setTime(lastModified);
                zipEntry.setMethod(this.compress ? 8 : 0);
                if (!this.compress) {
                    zipEntry.setSize(size);
                    zipEntry.setCompressedSize(size);
                    zipEntry.setCrc(0xFFFFFFFFL & checksum);
                }
                zos.putNextEntry(zipEntry);
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Error while adding entry " + entryPath, ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            try {
                zos.closeEntry();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public void addDirectoryEntry(String entryPath) {
        ZipOutputStream zos = this.getZipOutputStream();
        try {
            try {
                String path = entryPath.replace('\\', '/');
                if (!path.endsWith("/")) {
                    path = String.valueOf(path) + "/";
                }
                ZipEntry zipEntry = new ZipEntry(path);
                zos.putNextEntry(zipEntry);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error while adding entry " + entryPath, ex);
            }
        }
        finally {
            try {
                zos.closeEntry();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public void close() {
        if (this.zipOutputStream != null) {
            try {
                this.zipOutputStream.close();
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private ZipOutputStream getZipOutputStream() {
        if (this.zipOutputStream == null) {
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this.zipFile);
                this.zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
            }
            catch (Exception ex) {
                IOUtils.closeQuietly(outputStream);
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
        return this.zipOutputStream;
    }
}

