/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.ExceptionWithStatus;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IPathCopier;
import ch.systemsx.cisd.common.filesystem.highwatermark.HostAwareFileWithHighwaterMark;
import ch.systemsx.cisd.common.filesystem.ssh.ISshCommandExecutor;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.server.IDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.LocalDataSetFileOperationsExcecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.RemoteDataSetFileOperationsExecutor;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.Copier;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPathCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.ISshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DataSetFileOperationsManager
implements IDataSetFileOperationsManager {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetFileOperationsManager.class);
    @Private
    static final String DESTINATION_KEY = "destination";
    @Private
    static final String TIMEOUT_KEY = "timeout";
    @Private
    static final String RSYNC_PASSWORD_FILE_KEY = "rsync-password-file";
    @Private
    static final String CHECK_EXISTENCE_FAILED = "couldn't check existence";
    @Private
    static final String DESTINATION_DOES_NOT_EXIST = "destination doesn't exist";
    @Private
    static final String RSYNC_EXEC = "rsync";
    @Private
    static final String SSH_EXEC = "ssh";
    @Private
    static final String GFIND_EXEC = "find";
    @Private
    static final long DEFAULT_TIMEOUT_SECONDS = 15L;
    static final String FOLDER_OF_AS_DELETED_MARKED_DATA_SETS = "DELETED";
    private final IDataSetFileOperationsExecutor executor;
    private final String destination;
    private final long timeoutInMillis;
    private final boolean isHosted;

    public DataSetFileOperationsManager(Properties properties, IPathCopierFactory pathCopierFactory, ISshCommandExecutorFactory sshCommandExecutorFactory) {
        String hostFile = PropertyUtils.getMandatoryProperty(properties, DESTINATION_KEY);
        HostAwareFileWithHighwaterMark hostAwareFile = HostAwareFileWithHighwaterMark.create(hostFile, -1L);
        String hostOrNull = hostAwareFile.tryGetHost();
        this.isHosted = hostOrNull != null;
        this.destination = hostAwareFile.getPath();
        long timeoutInSeconds = PropertyUtils.getLong(properties, TIMEOUT_KEY, 15L);
        this.timeoutInMillis = timeoutInSeconds * 1000L;
        if (hostOrNull == null) {
            File sshExecutable = null;
            File rsyncExecutable = Copier.getExecutable(properties, RSYNC_EXEC);
            IPathCopier copier = pathCopierFactory.create(rsyncExecutable, sshExecutable, this.timeoutInMillis);
            copier.check();
            String rsyncModule = hostAwareFile.tryGetRsyncModule();
            String rsyncPasswordFile = properties.getProperty(RSYNC_PASSWORD_FILE_KEY);
            this.executor = new LocalDataSetFileOperationsExcecutor(FileOperations.getMonitoredInstanceForCurrentThread(), copier, rsyncModule, rsyncPasswordFile);
        } else {
            File sshExecutable = Copier.getExecutable(properties, SSH_EXEC);
            File rsyncExecutable = Copier.getExecutable(properties, RSYNC_EXEC);
            File gfindExecutable = Copier.getExecutable(properties, GFIND_EXEC);
            IPathCopier copier = pathCopierFactory.create(rsyncExecutable, sshExecutable, this.timeoutInMillis);
            copier.check();
            String rsyncModule = hostAwareFile.tryGetRsyncModule();
            String rsyncPasswordFile = properties.getProperty(RSYNC_PASSWORD_FILE_KEY);
            FileUtilities.checkPathCopier(copier, hostOrNull, null, rsyncModule, rsyncPasswordFile, this.timeoutInMillis);
            ISshCommandExecutor sshCommandExecutor = sshCommandExecutorFactory.create(sshExecutable, hostOrNull);
            this.executor = new RemoteDataSetFileOperationsExecutor(sshCommandExecutor, copier, gfindExecutable, hostOrNull, rsyncModule, rsyncPasswordFile, this.timeoutInMillis);
        }
    }

    @Override
    public Status copyToDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.destination, dataset.getDataSetLocation());
            if (this.createFolderIfNotExists(destinationFolder.getParentFile()) || !this.destinationExists(destinationFolder).isSuccess()) {
                operationLog.info("Copy dataset '" + dataset.getDataSetCode() + "' from '" + originalData.getPath() + "' to '" + destinationFolder.getParentFile());
                this.executor.copyDataSetToDestination(originalData, destinationFolder.getParentFile());
            } else {
                operationLog.info("Update dataset '" + dataset.getDataSetCode() + "' from '" + originalData.getPath() + "' to '" + destinationFolder.getParentFile());
                this.executor.syncDataSetWithDestination(originalData, destinationFolder.getParentFile());
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status retrieveFromDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.destination, dataset.getDataSetLocation());
            this.checkDestinationExists(destinationFolder);
            File folder = originalData.getParentFile();
            operationLog.info("Retrieve data set '" + dataset.getDataSetCode() + "' from '" + destinationFolder.getPath() + "' to '" + folder);
            folder.mkdirs();
            this.executor.retrieveDataSetFromDestination(folder, destinationFolder);
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public Status deleteFromDestination(IDatasetLocation dataset) {
        return this.delete(dataset, new IDeleteAction(){

            @Override
            public String getName() {
                return "delete";
            }

            @Override
            public void delete(File dataSetFolder, String dataSetCode) {
                DataSetFileOperationsManager.this.executor.deleteFolder(dataSetFolder);
            }
        });
    }

    @Override
    public Status markAsDeleted(IDatasetLocation dataset) {
        return this.delete(dataset, new IDeleteAction(){

            @Override
            public String getName() {
                return "mark as deleted";
            }

            @Override
            public void delete(File dataSetFolder, String dataSetCode) {
                File deletedFolder = new File(DataSetFileOperationsManager.this.destination, DataSetFileOperationsManager.FOLDER_OF_AS_DELETED_MARKED_DATA_SETS);
                DataSetFileOperationsManager.this.executor.createFolder(deletedFolder);
                File markerFile = new File(deletedFolder, dataSetCode);
                DataSetFileOperationsManager.this.executor.createMarkerFile(markerFile);
            }
        });
    }

    private Status delete(IDatasetLocation dataset, IDeleteAction action) {
        try {
            File destinationFolder = new File(this.destination, dataset.getDataSetLocation());
            BooleanStatus destinationExists = this.destinationExists(destinationFolder);
            if (destinationExists.isSuccess()) {
                action.delete(destinationFolder, dataset.getDataSetCode());
            } else {
                operationLog.info("Data of data set '" + dataset.getDataSetCode() + "' don't exist in the destination '" + destinationFolder.getPath() + "'. There is nothing to " + action.getName() + ".");
            }
            return Status.OK;
        }
        catch (ExceptionWithStatus ex) {
            return ex.getStatus();
        }
    }

    @Override
    public BooleanStatus isSynchronizedWithDestination(File originalData, DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.destination, dataset.getDataSetLocation());
            BooleanStatus resultStatus = this.executor.checkSame(originalData, destinationFolder);
            String message = resultStatus.tryGetMessage();
            if (message != null) {
                operationLog.error(message);
            }
            return resultStatus;
        }
        catch (ExceptionWithStatus ex) {
            return BooleanStatus.createError(ex.getStatus().toString());
        }
    }

    @Override
    public BooleanStatus isPresentInDestination(DatasetDescription dataset) {
        try {
            File destinationFolder = new File(this.destination, dataset.getDataSetLocation());
            BooleanStatus resultStatus = this.executor.exists(destinationFolder);
            String message = resultStatus.tryGetMessage();
            if (message != null) {
                operationLog.error(message);
            }
            return resultStatus;
        }
        catch (ExceptionWithStatus ex) {
            return BooleanStatus.createError(ex.getStatus().toString());
        }
    }

    private void checkDestinationExists(File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(destinationFolder);
        if (!destinationExists.isSuccess()) {
            operationLog.error("Destination folder '" + destinationFolder + "' doesn't exist");
            throw new ExceptionWithStatus(Status.createError(DESTINATION_DOES_NOT_EXIST));
        }
    }

    private boolean createFolderIfNotExists(File destinationFolder) {
        BooleanStatus destinationExists = this.destinationExists(destinationFolder);
        if (!destinationExists.isSuccess()) {
            this.executor.createFolder(destinationFolder);
            return true;
        }
        return false;
    }

    private BooleanStatus destinationExists(File destinationFolder) {
        BooleanStatus destinationExists = this.executor.exists(destinationFolder);
        if (destinationExists.isError()) {
            operationLog.error("Could not check existence of '" + destinationFolder + "': " + destinationExists.tryGetMessage());
            throw new ExceptionWithStatus(Status.createError(CHECK_EXISTENCE_FAILED));
        }
        return destinationExists;
    }

    @Override
    public boolean isHosted() {
        return this.isHosted;
    }

    @Override
    public IHierarchicalContent getAsHierarchicalContent(DatasetDescription dataset) {
        return new DefaultFileBasedHierarchicalContentFactory().asHierarchicalContent(new File(this.destination, dataset.getDataSetLocation()), null);
    }

    private static interface IDeleteAction {
        public String getName();

        public void delete(File var1, String var2);
    }
}

