/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.console;

import ch.systemsx.cisd.common.string.Template;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class ScriptContext {
    private final Map<String, String> bindings = new HashMap<String, String>();

    ScriptContext(Properties properties) {
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            this.bind((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void bind(String variable, String value) {
        this.bindings.put(variable, value);
    }

    public String resolveVariables(String argument) {
        Template template = new Template(argument);
        Set<String> placeholderNames = template.getPlaceholderNames();
        for (String placeholderName : placeholderNames) {
            String value = this.bindings.get(placeholderName);
            if (value == null) {
                throw new IllegalArgumentException("Place holder '" + placeholderName + "' is undefined.");
            }
            template.bind(placeholderName, value);
        }
        return template.createText();
    }
}

