/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class MaterialDisambiguationProvider
extends AbstractTableModelProvider<Material> {
    private final List<Material> materials;

    public MaterialDisambiguationProvider(List<Material> materials) {
        this.materials = materials;
    }

    @Override
    protected TypedTableModel<Material> createTableModel() {
        TypedTableModelBuilder<Material> builder = new TypedTableModelBuilder<Material>();
        this.addStandardColumns(builder);
        for (Material material : this.materials) {
            this.addRow(builder, material);
        }
        return builder.getModel();
    }

    private void addStandardColumns(TypedTableModelBuilder<Material> builder) {
        builder.addColumn("CODE");
        builder.addColumn("MATERIAL_TYPE");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("REGISTRATOR").withDefaultWidth(200).hideByDefault();
    }

    private void addRow(TypedTableModelBuilder<Material> builder, Material material) {
        builder.addRow(material);
        builder.column("CODE").addString(material.getCode());
        builder.column("MATERIAL_TYPE").addString(material.getEntityType().getCode());
        builder.column("REGISTRATION_DATE").addDate(material.getRegistrationDate());
        builder.column("REGISTRATOR").addPerson(material.getRegistrator());
        builder.columnGroup("property-").addProperties(material.getProperties());
    }
}

