/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public abstract class PersistentEntityPredicate<T>
implements IPredicate<T> {
    private final boolean isReadAccess;

    public PersistentEntityPredicate() {
        this(false);
    }

    public PersistentEntityPredicate(boolean isReadAccess) {
        this.isReadAccess = isReadAccess;
    }

    @Override
    public Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T value) throws UserFailureException {
        boolean isInstanceEntity;
        if (value == null) {
            return Status.createError("null value cannot be authorized");
        }
        SpacePE space = this.getSpace(value);
        boolean bl = isInstanceEntity = space == null;
        if (isInstanceEntity && this.isReadAccess) {
            return Status.OK;
        }
        DatabaseInstancePE instance = isInstanceEntity ? this.getInstance(value) : space.getDatabaseInstance();
        for (RoleWithIdentifier allowed : allowedRoles) {
            RoleWithHierarchy.RoleLevel level = allowed.getRoleLevel();
            if (level.equals((Object)RoleWithHierarchy.RoleLevel.INSTANCE) && allowed.getAssignedDatabaseInstance().equals(instance)) {
                return Status.OK;
            }
            if (!level.equals((Object)RoleWithHierarchy.RoleLevel.SPACE) || !allowed.getAssignedSpace().equals(space)) continue;
            return Status.OK;
        }
        return Status.createError(String.valueOf(person.getUserId()) + " does not have enough privileges.");
    }

    public abstract SpacePE getSpace(T var1);

    public abstract DatabaseInstancePE getInstance(T var1);

    @Override
    public void init(IAuthorizationDataProvider provider) {
    }
}

