/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IEntityOperationChecker;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractSampleBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IEntityPropertiesConverter;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SamplePermIdId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.SampleTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public final class SampleBO
extends AbstractSampleBusinessObject
implements ISampleBO {
    private SamplePE sample;
    private final List<AttachmentPE> attachments = new ArrayList<AttachmentPE>();
    private boolean dataChanged;
    private boolean spaceUpdated;

    public SampleBO(IDAOFactory daoFactory, Session session, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, relationshipService, entityOperationChecker, managedPropertyEvaluatorFactory);
    }

    SampleBO(IDAOFactory daoFactory, Session session, IEntityPropertiesConverter entityPropertiesConverter, IRelationshipService relationshipService, IEntityOperationChecker entityOperationChecker, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, entityPropertiesConverter, relationshipService, entityOperationChecker, managedPropertyEvaluatorFactory);
    }

    @Override
    public SamplePE tryToGetSample() {
        return this.sample;
    }

    @Override
    public SamplePE tryFindBySampleId(ISampleId sampleId) {
        if (sampleId == null) {
            throw new IllegalArgumentException("Sample id cannot be null");
        }
        if (sampleId instanceof SampleIdentifierId) {
            SampleIdentifierId identifierId = (SampleIdentifierId)sampleId;
            SampleIdentifier identifier = new SampleIdentifierFactory(identifierId.getIdentifier()).createIdentifier();
            return this.tryToGetSampleByIdentifier(identifier);
        }
        if (sampleId instanceof SamplePermIdId) {
            SamplePermIdId permIdId = (SamplePermIdId)sampleId;
            return this.getSampleDAO().tryToFindByPermID(permIdId.getPermId());
        }
        if (sampleId instanceof SampleTechIdId) {
            SampleTechIdId techIdId = (SampleTechIdId)sampleId;
            return (SamplePE)this.getSampleDAO().tryGetByTechId(new TechId(techIdId.getTechId()), new String[0]);
        }
        throw new IllegalArgumentException("Unsupported sample id: " + sampleId);
    }

    @Override
    public void tryToLoadBySampleIdentifier(SampleIdentifier identifier) {
        assert (identifier != null) : "Unspecified identifier.";
        this.sample = this.tryToGetSampleByIdentifier(identifier);
    }

    public void tryToLoadBySamplePermId(String permId) {
        assert (permId != null) : "Unspecified perm id.";
        this.sample = this.getSampleDAO().tryToFindByPermID(permId);
    }

    public void tryToLoadBySampleTechId(TechId sampleId) {
        assert (sampleId != null) : "Unspecified id.";
        this.sample = this.tryToGetSampleByTechId(sampleId);
    }

    @Override
    public final SamplePE getSample() throws IllegalStateException {
        if (this.sample == null) {
            throw new IllegalStateException("Unloaded sample.");
        }
        return this.sample;
    }

    @Override
    public void loadDataByTechId(TechId sampleId) {
        this.onlyNewSamples = false;
        this.tryToLoadBySampleTechId(sampleId);
        if (this.sample == null) {
            throw new UserFailureException(String.format("Sample with ID '%s' does not exist.", sampleId));
        }
        this.spaceUpdated = false;
        this.dataChanged = false;
    }

    @Override
    public final void loadBySampleIdentifier(SampleIdentifier identifier) throws UserFailureException {
        this.tryToLoadBySampleIdentifier(identifier);
        if (this.sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found with given identifier '%s'.", identifier);
        }
    }

    @Override
    public final void loadBySamplePermId(String permId) throws UserFailureException {
        this.tryToLoadBySamplePermId(permId);
        if (this.sample == null) {
            throw UserFailureException.fromTemplate("No sample could be found with given permId '%s'.", permId);
        }
    }

    @Override
    public final void define(NewSample newSample) {
        assert (newSample != null) : "Unspecified new sample.";
        this.assertInstanceSampleCreationAllowed(Collections.singletonList(newSample));
        this.sample = this.createSample(newSample, null, null, null, null);
        this.addAttachments(this.sample, newSample.getAttachments(), this.attachments);
        this.spaceUpdated = true;
        this.dataChanged = true;
        this.onlyNewSamples = true;
    }

    @Override
    public final void save() {
        assert (this.sample != null) : "Sample not loaded.";
        if (this.dataChanged) {
            try {
                this.getSampleDAO().createOrUpdateSample(this.sample, this.findPerson());
            }
            catch (DataIntegrityViolationException ex) {
                throw new UserFailureException(ex.getMessage(), ex);
            }
            catch (DataAccessException ex) {
                SampleBO.throwException(ex, String.format("Sample '%s'", this.sample.getSampleIdentifier()));
            }
            try {
                this.checkAllBusinessRules(this.sample, this.getDataDAO(), null, this.spaceUpdated);
            }
            finally {
                this.spaceUpdated = false;
                this.dataChanged = false;
                this.onlyNewSamples = false;
            }
        }
        this.saveAttachment(this.sample, this.attachments);
    }

    @Override
    public void setExperiment(ExperimentPE experiment) {
        assert (this.sample != null) : "Sample not loaded.";
        SampleBO.checkAvailable(this.sample);
        SampleBO.checkSampleInGroup(this.sample);
        SampleBO.checkSampleUnused(this.sample);
        this.checkSampleWithoutDatasets();
        this.relationshipService.assignSampleToExperiment(this.session, this.sample, experiment);
        try {
            this.getSampleDAO().updateSample(this.sample, this.findPerson());
        }
        catch (DataAccessException ex) {
            SampleBO.throwException(ex, String.format("Couldn't update sample '%s'", this.sample.getSampleIdentifier()));
        }
        this.spaceUpdated = false;
        this.dataChanged = false;
    }

    private static void checkAvailable(SamplePE sample) {
        if (sample.getDeletion() != null) {
            throw UserFailureException.fromTemplate("Given sample '%s' is in trash.", sample.getSampleIdentifier());
        }
    }

    private final void checkSampleWithoutDatasets() {
        SampleUtils.checkSampleWithoutDatasets(this.getDataDAO(), this.sample);
    }

    private static final void checkSampleUnused(SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null && experiment.getDeletion() == null) {
            throw UserFailureException.fromTemplate("Given sample code '%s' already registered for experiment '%s'.", sample.getSampleIdentifier(), IdentifierHelper.createExperimentIdentifier(experiment));
        }
    }

    private static final void checkSampleInGroup(SamplePE sample) {
        if (sample.getSpace() == null) {
            throw UserFailureException.fromTemplate("The sample '%s' is shared and cannot be assigned to any experiment.", sample.getSampleIdentifier());
        }
    }

    @Override
    public void update(SampleUpdatesDTO updates) {
        this.loadDataByTechId(updates.getSampleIdOrNull());
        this.assertInstanceSampleUpdateAllowed(Collections.singletonList(this.sample));
        if (updates.getVersion() != this.sample.getVersion()) {
            SampleBO.throwModifiedEntityException("Sample");
        }
        this.updateProperties(this.sample.getSampleType(), updates.getProperties(), this.sample, this.sample);
        this.spaceUpdated = this.updateSpace(this.sample, updates.getSampleIdentifier(), null);
        if (updates.isUpdateExperimentLink()) {
            this.updateExperiment(this.sample, updates.getExperimentIdentifierOrNull(), null);
        }
        this.setContainer(updates.getSampleIdentifier(), this.sample, updates.getContainerIdentifierOrNull(), null);
        this.addAttachments(this.sample, updates.getAttachments(), this.attachments);
        this.updateParents(updates);
        this.setMetaprojects(this.sample, updates.getMetaprojectsOrNull());
        this.dataChanged = true;
    }

    private void updateParents(SampleUpdatesDTO updates) {
        String[] parentCodes = updates.getModifiedParentCodesOrNull();
        if (parentCodes != null) {
            this.attachParents(parentCodes);
        }
    }

    private void attachParents(String[] parentCodes) {
        this.setParents(this.sample, parentCodes, null);
    }

    @Override
    public void addAttachment(AttachmentPE attachment) {
        assert (this.sample != null) : "no sample has been loaded";
        this.assertInstanceSampleUpdateAllowed(Collections.singletonList(this.sample));
        this.prepareAttachment((IModifierAndModificationDateBean)this.sample, attachment);
        this.attachments.add(attachment);
    }

    private void checkSampleLoaded() {
        if (this.sample == null) {
            throw new IllegalStateException("Unloaded sample.");
        }
    }

    @Override
    public AttachmentPE tryGetSampleFileAttachment(String fileName, Integer versionOrNull) {
        AttachmentPE att;
        this.checkSampleLoaded();
        this.sample.ensureAttachmentsLoaded();
        AttachmentPE attachmentPE = att = versionOrNull == null ? this.getAttachment(fileName) : this.getAttachment(fileName, versionOrNull);
        if (att != null) {
            HibernateUtils.initialize(att.getAttachmentContent());
            return att;
        }
        return null;
    }

    @Override
    public AttachmentPE getSampleFileAttachment(String filename, Integer versionOrNull) {
        AttachmentPE attachment = this.tryGetSampleFileAttachment(filename, versionOrNull);
        if (attachment != null) {
            return attachment;
        }
        throw new UserFailureException("Attachment '" + filename + "' " + (versionOrNull == null ? "(latest version)" : "(version '" + versionOrNull + "')") + " not found in sample '" + this.sample.getIdentifier() + "'.");
    }

    private AttachmentPE getAttachment(String filename, int version) {
        Set<AttachmentPE> attachmentsSet = this.sample.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || att.getVersion() != version) continue;
            return att;
        }
        return null;
    }

    private AttachmentPE getAttachment(String filename) {
        AttachmentPE latest = null;
        Set<AttachmentPE> attachmentsSet = this.sample.getAttachments();
        for (AttachmentPE att : attachmentsSet) {
            if (!att.getFileName().equals(filename) || latest != null && latest.getVersion() >= att.getVersion()) continue;
            latest = att;
        }
        return latest;
    }

    @Override
    public final void enrichWithAttachments() {
        if (this.sample != null) {
            this.sample.ensureAttachmentsLoaded();
        }
    }

    @Override
    public final void enrichWithPropertyTypes() {
        if (this.sample != null) {
            HibernateUtils.initialize(this.sample.getSampleType());
            HibernateUtils.initialize(this.sample.getSampleType().getSampleTypePropertyTypes());
        }
    }

    @Override
    public void enrichWithProperties() {
        if (this.sample != null) {
            HibernateUtils.initialize(this.sample.getProperties());
        }
    }

    @Override
    public void updateManagedProperty(IManagedProperty managedProperty) {
        this.assertInstanceSampleUpdateAllowed(Collections.singletonList(this.sample));
        Set<SamplePropertyPE> existingProperties = this.sample.getProperties();
        SampleTypePE type = this.sample.getSampleType();
        PersonPE registrator = this.findPerson();
        this.sample.setProperties(this.entityPropertiesConverter.updateManagedProperty(existingProperties, type, managedProperty, registrator));
        this.dataChanged = true;
    }
}

