/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IProjectDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class ProjectDAO
extends AbstractGenericEntityDAO<ProjectPE>
implements IProjectDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ProjectDAO.class);

    protected ProjectDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance) {
        super(sessionFactory, databaseInstance, ProjectPE.class);
    }

    @Override
    public List<ProjectPE> listProjects() {
        List<ProjectPE> list = ProjectDAO.cast(this.getHibernateTemplate().loadAll(ProjectPE.class));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(): %d projects(s) have been found.", MethodUtils.getCurrentMethod().getName(), list.size()));
        }
        return list;
    }

    @Override
    public List<ProjectPE> listProjects(SpacePE space) {
        assert (space != null) : "Unspecified space.";
        DetachedCriteria criteria = DetachedCriteria.forClass(ProjectPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"space", (Object)space));
        List<ProjectPE> list = ProjectDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(%s): %d project(s) have been found.", MethodUtils.getCurrentMethod().getName(), space, list.size()));
        }
        return list;
    }

    @Override
    public ProjectPE tryGetByPermID(String permId) {
        Criteria criteria = this.getSession().createCriteria(this.getEntityClass());
        criteria.add((Criterion)Restrictions.eq((String)"permId", (Object)permId));
        ProjectPE projectOrNull = (ProjectPE)criteria.uniqueResult();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Following project '%s' has been found for permId '%s'.", projectOrNull, permId));
        }
        return projectOrNull;
    }

    @Override
    public ProjectPE tryFindProject(String databaseInstanceCode, String spaceCode, String projectCode) {
        assert (projectCode != null) : "Unspecified project code.";
        assert (spaceCode != null) : "Unspecified space code.";
        Criteria criteria = this.getSession().createCriteria(ProjectPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(projectCode)));
        Criteria spaceCriteria = criteria.createCriteria("space");
        spaceCriteria.add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(spaceCode)));
        if (StringUtils.isBlank((String)databaseInstanceCode)) {
            spaceCriteria.add((Criterion)Restrictions.eq((String)"databaseInstance", (Object)this.getDatabaseInstance()));
        } else {
            spaceCriteria.createCriteria("databaseInstance").add((Criterion)Restrictions.eq((String)"code", (Object)CodeConverter.tryToDatabase(databaseInstanceCode)));
        }
        return (ProjectPE)criteria.uniqueResult();
    }

    @Override
    public List<ProjectPE> tryFindProjects(List<ProjectIdentifier> projectIdentifiers) {
        List<ProjectPE> allProjects = this.listProjects();
        LinkedList<ProjectPE> matchingProjects = new LinkedList<ProjectPE>();
        HashSet<ProjectIdentifier> projectIdentifiersSet = new HashSet<ProjectIdentifier>();
        for (ProjectIdentifier projectIdentifier : projectIdentifiers) {
            projectIdentifiersSet.add(IdentifierHelper.createFullProjectIdentifier(projectIdentifier, this.getDatabaseInstance()));
        }
        for (ProjectPE project : allProjects) {
            if (!projectIdentifiersSet.contains(IdentifierHelper.createFullProjectIdentifier(project))) continue;
            matchingProjects.add(project);
        }
        return matchingProjects;
    }

    @Override
    public void createProject(ProjectPE project, PersonPE modifier) {
        assert (project != null) : "Missing project.";
        ProjectDAO.validatePE(project);
        project.setCode(CodeConverter.tryToDatabase(project.getCode()));
        project.setModifier(modifier);
        project.setModificationDate(new Date());
        HibernateTemplate template = this.getHibernateTemplate();
        template.saveOrUpdate((Object)project);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("SAVE: project '%s'.", project));
        }
    }
}

