/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.FileUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.BasicUserInfoDTO;
import ch.systemsx.cisd.cifex.shared.basic.dto.OwnerFileInfoDTO;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public class AdminFileGridModel
extends AbstractFileGridModel {
    private static final long serialVersionUID = 1L;

    public static final List<ColumnConfig> getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(AdminFileGridModel.createIdColumnConfig());
        configs.add(AdminFileGridModel.createNameColumnConfig());
        configs.add(AdminFileGridModel.createCommentColumnConfig());
        configs.add(AdminFileGridModel.createOwnerColumnConfig());
        configs.add(AdminFileGridModel.createRegistratorColumnConfig());
        configs.add(AdminFileGridModel.createSharedWithColumnConfig());
        configs.add(AdminFileGridModel.createContentTypeColumnConfig());
        configs.add(AdminFileGridModel.createSizeColumnConfig());
        configs.add(AdminFileGridModel.createCompleteSizeColumnConfig());
        configs.add(AdminFileGridModel.createIsCompleteColumnConfig());
        configs.add(AdminFileGridModel.createCRC32ChecksumColumnConfig());
        configs.add(AdminFileGridModel.createRegistrationDateColumnConfig());
        configs.add(AdminFileGridModel.createExpirationDateColumnConfig());
        configs.add(AdminFileGridModel.createActionColumnConfig());
        return configs;
    }

    public AdminFileGridModel(OwnerFileInfoDTO file) {
        this.set("id", file.getID());
        this.set("name", file.getName());
        this.set("comment", file.getComment());
        this.set("owner", file.getOwner());
        this.set("registrator", file.getRegistratorCode());
        this.set("sharedWith", BasicUserInfoDTO.concatUserCodes(file.getSharingUsers()));
        this.set("contentType", file.getContentType());
        this.set("size", FileUtils.tryToGetFileSize(file));
        this.set("completeSize", new Double(file.getCompleteSize()));
        this.set("isComplete", file.isComplete());
        this.set("crc32Checksum", file.getCrc32Str());
        this.set("registrationDate", file.getRegistrationDate());
        this.set("expirationDate", file.getExpirationDate());
        this.set("action", String.valueOf(DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_EDIT_LABEL), "edit")) + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_EDITSHARING_LABEL), "shared") + " | " + DOMUtils.createAnchor(MessageDictionary.msg(MessageDictionary.ACTION_DELETE_LABEL), "delete"));
    }

    public static final List<AbstractFileGridModel> convert(List<OwnerFileInfoDTO> filters) {
        ArrayList<AbstractFileGridModel> result = new ArrayList<AbstractFileGridModel>();
        for (OwnerFileInfoDTO filter : filters) {
            result.add(new AdminFileGridModel(filter));
        }
        return result;
    }

    @Override
    public long getID() {
        return (Long)this.get("id");
    }
}

